/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMBidderPartialMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMWorldPartialMip;

public class MRVMNationalBidderPartialMip
extends MRVMBidderPartialMIP {
    public static final String W_ir_VARIABLE_PREFIX = "GlobalBidder_W_ir_";
    private static final String W_i_VARIABLE_PREFIX = "GlobalBidder_W_i_";
    private static final String W_hat_ik_VARIABLE_PREFIX = "GlobalBidder_hat{W}_";
    private static final String PSI_VARIABLE_PREFIX = "GlobalBidder_PSI_";
    private final MRVMNationalBidder bidder;
    private Map<Integer, Variable> psiVariables;
    private Map<Integer, Variable> wHatIKVariables;
    private Variable wIVariable;
    private Map<MRVMRegionsMap.Region, Variable> wIRVariables;

    public MRVMNationalBidderPartialMip(MRVMNationalBidder bidder, double scalingFactor, MRVMWorldPartialMip worldMip) {
        super((MRVMBidder)bidder, scalingFactor, worldMip);
        this.bidder = bidder;
        this.psiVariables = this.createPsiVariables();
        this.wHatIKVariables = this.createwHatIKVariables();
        this.wIVariable = this.createWIVariable();
        this.wIRVariables = this.createWIRVariables();
    }

    private Map<MRVMRegionsMap.Region, Variable> createWIRVariables() {
        HashMap<MRVMRegionsMap.Region, Variable> result = new HashMap<MRVMRegionsMap.Region, Variable>();
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            String name = W_ir_VARIABLE_PREFIX.concat(MRVMNationalBidderPartialMip.createIndex(this.bidder, region));
            result.put(region, new Variable(name, VarType.BOOLEAN, 0.0, 1.0));
        }
        return result;
    }

    private Variable createWIVariable() {
        String name = W_i_VARIABLE_PREFIX.concat(String.valueOf(this.bidder.getId()));
        int numberOfRegions = this.bidder.getWorld().getRegionsMap().getNumberOfRegions();
        return new Variable(name, VarType.INT, 0.0, (double)numberOfRegions);
    }

    private Map<Integer, Variable> createwHatIKVariables() {
        HashMap<Integer, Variable> result = new HashMap<Integer, Variable>();
        for (int k = 0; k <= this.bidder.getKMax(); ++k) {
            String name = W_hat_ik_VARIABLE_PREFIX.concat(MRVMNationalBidderPartialMip.createIndex(this.bidder, k));
            result.put(k, new Variable(name, VarType.BOOLEAN, 0.0, 1.0));
        }
        return result;
    }

    static String createIndex(Bidder<?> bidder, Integer k) {
        StringBuilder builder = new StringBuilder("_i");
        builder.append(bidder.getId());
        builder.append(",k");
        builder.append(k.toString());
        return builder.toString();
    }

    private Map<Integer, Variable> createPsiVariables() {
        HashMap<Integer, Variable> result = new HashMap<Integer, Variable>();
        for (int k = 0; k <= this.bidder.getKMax(); ++k) {
            String name = PSI_VARIABLE_PREFIX.concat(MRVMNationalBidderPartialMip.createIndex(this.bidder, k));
            result.put(k, new Variable(name, VarType.DOUBLE, 0.0, 5.3687091E8));
        }
        return result;
    }

    public Variable getWIRVariable(MRVMRegionsMap.Region region) {
        Variable var = this.wIRVariables.get(region);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    public Variable getWIVariable() {
        return this.wIVariable;
    }

    public Variable getWHatIKVariable(int k) {
        return this.wHatIKVariables.get(k);
    }

    public Variable getPsi(int k) {
        return this.psiVariables.get(k);
    }

    Constraint valueConstraint() {
        Constraint constraint = new Constraint(CompareType.EQ, 0.0);
        constraint.addTerm(-1.0, this.worldPartialMip.getValueVariable((MRVMBidder)this.bidder));
        for (int k = 0; k <= this.bidder.getKMax(); ++k) {
            double discount = this.bidder.getGamma(k).doubleValue();
            constraint.addTerm(discount, this.getPsi(k));
        }
        return constraint;
    }

    List<Constraint> constrainWIR() {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        int bigM = 0;
        for (MRVMBand band : this.bidder.getWorld().getBands()) {
            bigM += band.getNumberOfLicenses();
        }
        double smallM = 1.0 / (double)bigM;
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            Constraint constraintOne = new Constraint(CompareType.GEQ, 0.0);
            constraintOne.addTerm(-1.0, this.getWIRVariable(region));
            Constraint constraintTwo = new Constraint(CompareType.LEQ, 0.0);
            constraintTwo.addTerm(-1.0, this.getWIRVariable(region));
            for (MRVMBand band : this.bidder.getWorld().getBands()) {
                Variable xVariable = this.worldPartialMip.getXVariable((MRVMBidder)this.bidder, region, band);
                constraintOne.addTerm(1.0, xVariable);
                constraintTwo.addTerm(smallM, xVariable);
            }
            constraints.add(constraintOne);
            constraints.add(constraintTwo);
        }
        return constraints;
    }

    Constraint constainWi() {
        Constraint constraint = new Constraint(CompareType.EQ, 0.0);
        constraint.addTerm(-1.0, this.getWIVariable());
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            constraint.addTerm(1.0, this.getWIRVariable(region));
        }
        return constraint;
    }

    List<Constraint> constrainWHat() {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        int numberOfRegions = this.bidder.getWorld().getRegionsMap().getNumberOfRegions();
        int kMax = this.bidder.getKMax();
        for (int k = 0; k < kMax; ++k) {
            double bigM = numberOfRegions;
            Constraint constraintOne = new Constraint(CompareType.LEQ, bigM + (double)numberOfRegions - (double)k);
            Constraint constraintTwo = new Constraint(CompareType.GEQ, -1.0 * bigM + (double)numberOfRegions - (double)k);
            Variable WI = this.getWIVariable();
            constraintOne.addTerm(1.0, WI);
            constraintTwo.addTerm(1.0, WI);
            Variable wHat = this.getWHatIKVariable(k);
            constraintOne.addTerm(bigM, wHat);
            constraintTwo.addTerm(-1.0 * bigM, wHat);
            constraints.add(constraintOne);
            constraints.add(constraintTwo);
        }
        double bigM = numberOfRegions;
        Constraint constraintOne = new Constraint(CompareType.LEQ, bigM + (double)numberOfRegions - (double)kMax);
        Variable WI = this.getWIVariable();
        constraintOne.addTerm(1.0, WI);
        Variable wHat = this.getWHatIKVariable(kMax);
        constraintOne.addTerm(bigM, wHat);
        constraints.add(constraintOne);
        Constraint constraintTwo = new Constraint(CompareType.GEQ, (double)(numberOfRegions - kMax + 1));
        constraintTwo.addTerm((double)(numberOfRegions - kMax + 1), wHat);
        constraintTwo.addTerm(1.0, WI);
        constraints.add(constraintTwo);
        return constraints;
    }

    List<Constraint> constrainPsi() {
        Constraint constraint;
        int k;
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        double bigM = this.worldPartialMip.getBiggestPossibleValue();
        for (k = 0; k <= this.bidder.getKMax(); ++k) {
            constraint = new Constraint(CompareType.GEQ, -1.0 * bigM);
            constraint.addTerm(-1.0 * bigM, this.getWHatIKVariable(k));
            constraint.addTerm(-1.0, this.getPsi(k));
            for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
                constraint.addTerm(1.0, this.getOmegaVariable(region));
            }
            result.add(constraint);
        }
        for (k = 0; k <= this.bidder.getKMax(); ++k) {
            constraint = new Constraint(CompareType.LEQ, bigM);
            constraint.addTerm(-1.0, this.getPsi(k));
            constraint.addTerm(bigM, this.getWHatIKVariable(k));
            for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
                constraint.addTerm(1.0, this.getOmegaVariable(region));
            }
            result.add(constraint);
        }
        for (k = 0; k <= this.bidder.getKMax(); ++k) {
            constraint = new Constraint(CompareType.LEQ, 0.0);
            constraint.addTerm(1.0, this.getPsi(k));
            constraint.addTerm(-1.0 * bigM, this.getWHatIKVariable(k));
            result.add(constraint);
        }
        return result;
    }

    @Override
    public void appendVariablesToMip(MIP mip) {
        super.appendVariablesToMip(mip);
        for (Variable var : this.psiVariables.values()) {
            mip.add(var);
        }
        for (Variable var : this.wHatIKVariables.values()) {
            mip.add(var);
        }
        for (Variable var : this.wIRVariables.values()) {
            mip.add(var);
        }
        mip.add(this.wIVariable);
    }

    @Override
    public void appendConstraintsToMip(MIP mip) {
        super.appendConstraintsToMip(mip);
        mip.add(this.valueConstraint());
        for (Constraint constraint : this.constrainWIR()) {
            mip.add(constraint);
        }
        mip.add(this.constainWi());
        for (Constraint constraint : this.constrainWHat()) {
            mip.add(constraint);
        }
        for (Constraint constraint : this.constrainPsi()) {
            mip.add(constraint);
        }
    }
}

