/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLocalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.opt.model.EfficientAllocator;
import org.spectrumauctions.sats.opt.model.GenericAllocation;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMBidderPartialMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMLocalBidderPartialMip;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMMipResult;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMNationalBidderPartialMip;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMRegionalBidderPartialMip;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMWorldPartialMip;
import org.spectrumauctions.sats.opt.model.mrvm.Scalor;

public class MRVM_MIP
extends ModelMIP
implements EfficientAllocator<GenericAllocation<MRVMGenericDefinition>> {
    private static final Logger logger = LogManager.getLogger(MRVM_MIP.class);
    public static boolean PRINT_SOLVER_RESULT = false;
    private static SolverClient SOLVER = new SolverClient();
    private MRVMWorldPartialMip worldPartialMip;
    private Map<MRVMBidder, MRVMBidderPartialMIP> bidderPartialMips;
    private MRVMWorld world;

    public MRVM_MIP(Collection<MRVMBidder> bidders) {
        Preconditions.checkNotNull(bidders);
        Preconditions.checkArgument((bidders.size() > 0 ? 1 : 0) != 0);
        this.world = bidders.iterator().next().getWorld();
        this.getMip().setSolveParam(SolveParam.RELATIVE_OBJ_GAP, (Object)0.001);
        double scalingFactor = Scalor.scalingFactor(bidders);
        double biggestPossibleValue = Scalor.biggestUnscaledPossibleValue(bidders).doubleValue() / scalingFactor;
        this.worldPartialMip = new MRVMWorldPartialMip(bidders, biggestPossibleValue);
        this.worldPartialMip.appendToMip(this.getMip());
        this.bidderPartialMips = new HashMap<MRVMBidder, MRVMBidderPartialMIP>();
        for (MRVMBidder bidder : bidders) {
            MRVMBidderPartialMIP bidderPartialMIP;
            MRVMNationalBidder globalBidder;
            if (bidder instanceof MRVMNationalBidder) {
                globalBidder = (MRVMNationalBidder)bidder;
                bidderPartialMIP = new MRVMNationalBidderPartialMip(globalBidder, scalingFactor, this.worldPartialMip);
            } else if (bidder instanceof MRVMLocalBidder) {
                globalBidder = (MRVMLocalBidder)bidder;
                bidderPartialMIP = new MRVMLocalBidderPartialMip((MRVMLocalBidder)globalBidder, scalingFactor, this.worldPartialMip);
            } else {
                globalBidder = (MRVMRegionalBidder)bidder;
                bidderPartialMIP = new MRVMRegionalBidderPartialMip((MRVMRegionalBidder)globalBidder, scalingFactor, this.worldPartialMip);
            }
            bidderPartialMIP.appendToMip(this.getMip());
            this.bidderPartialMips.put(bidder, bidderPartialMIP);
        }
    }

    public void addConstraint(Constraint constraint) {
        this.getMip().add(constraint);
    }

    public void addVariable(Variable variable) {
        this.getMip().add(variable);
    }

    @Override
    public MRVMMipResult calculateAllocation() {
        IMIPResult mipResult = SOLVER.solve((IMIP)this.getMip());
        if (PRINT_SOLVER_RESULT) {
            logger.info("Result:\n" + mipResult);
        }
        MRVMMipResult.Builder resultBuilder = new MRVMMipResult.Builder(mipResult.getObjectiveValue(), this.world, mipResult);
        for (Map.Entry<MRVMBidder, MRVMBidderPartialMIP> bidder : this.bidderPartialMips.entrySet()) {
            Variable bidderValueVar = this.worldPartialMip.getValueVariable(bidder.getKey());
            double mipUtilityResult = mipResult.getValue(bidderValueVar);
            double svScalingFactor = bidder.getValue().getScalingFactor();
            double unscaledValue = mipUtilityResult * svScalingFactor;
            GenericValue.Builder valueBuilder = new GenericValue.Builder(BigDecimal.valueOf(unscaledValue));
            for (MRVMRegionsMap.Region region : this.world.getRegionsMap().getRegions()) {
                for (MRVMBand band : this.world.getBands()) {
                    Variable xVar = this.worldPartialMip.getXVariable(bidder.getKey(), region, band);
                    double doubleQuantity = mipResult.getValue(xVar);
                    int quantity = (int)Math.round(doubleQuantity);
                    MRVMGenericDefinition def = new MRVMGenericDefinition(band, region);
                    valueBuilder.putQuantity((GenericDefinition)def, quantity);
                }
            }
            GenericValue build = valueBuilder.build();
            resultBuilder.putGenericValue((Bidder)bidder.getKey(), build);
        }
        return resultBuilder.build();
    }

    public MRVMWorldPartialMip getWorldPartialMip() {
        return this.worldPartialMip;
    }

    public Map<MRVMBidder, MRVMBidderPartialMIP> getBidderPartialMips() {
        return this.bidderPartialMips;
    }
}

