/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.srvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.generic.Band;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.opt.model.EfficientAllocator;
import org.spectrumauctions.sats.opt.model.GenericAllocation;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.srvm.SRVMBidderPartialMIP;
import org.spectrumauctions.sats.opt.model.srvm.SRVMMipResult;
import org.spectrumauctions.sats.opt.model.srvm.SRVMWorldPartialMip;

public class SRVM_MIP
extends ModelMIP
implements EfficientAllocator<GenericAllocation<SRVMBand>> {
    private static final Logger logger = LogManager.getLogger(SRVM_MIP.class);
    public static boolean PRINT_SOLVER_RESULT = false;
    private static SolverClient SOLVER = new SolverClient();
    public static BigDecimal highestValidVal = BigDecimal.valueOf(535870910L);
    private SRVMWorldPartialMip worldPartialMip;
    private Map<SRVMBidder, SRVMBidderPartialMIP> bidderPartialMips;
    private SRVMWorld world;

    public SRVM_MIP(Collection<SRVMBidder> bidders) {
        Preconditions.checkNotNull(bidders);
        Preconditions.checkArgument((bidders.size() > 0 ? 1 : 0) != 0);
        this.world = bidders.iterator().next().getWorld();
        this.getMip().setSolveParam(SolveParam.RELATIVE_OBJ_GAP, (Object)0.001);
        double scalingFactor = SRVM_MIP.calculateScalingFactor(bidders);
        double biggestPossibleValue = SRVM_MIP.biggestUnscaledPossibleValue(bidders).doubleValue() / scalingFactor;
        this.worldPartialMip = new SRVMWorldPartialMip(bidders, biggestPossibleValue, scalingFactor);
        this.worldPartialMip.appendToMip(this.getMip());
        this.bidderPartialMips = new HashMap<SRVMBidder, SRVMBidderPartialMIP>();
        for (SRVMBidder bidder : bidders) {
            SRVMBidderPartialMIP bidderPartialMIP = new SRVMBidderPartialMIP(bidder, this.worldPartialMip);
            bidderPartialMIP.appendToMip(this.getMip());
            this.bidderPartialMips.put(bidder, bidderPartialMIP);
        }
    }

    public static double calculateScalingFactor(Collection<SRVMBidder> bidders) {
        BigDecimal maxVal = SRVM_MIP.biggestUnscaledPossibleValue(bidders);
        if (maxVal.compareTo(highestValidVal) < 0) {
            return 1.0;
        }
        logger.info("Scaling MIP-CALC");
        return maxVal.divide(highestValidVal, RoundingMode.HALF_DOWN).doubleValue();
    }

    public static BigDecimal biggestUnscaledPossibleValue(Collection<SRVMBidder> bidders) {
        BigDecimal biggestValue = BigDecimal.ZERO;
        for (SRVMBidder bidder : bidders) {
            BigDecimal val = bidder.calculateValue(new Bundle((Collection)bidder.getWorld().getLicenses()));
            if (val.compareTo(biggestValue) <= 0) continue;
            biggestValue = val;
        }
        return biggestValue;
    }

    public void addConstraint(Constraint constraint) {
        this.getMip().add(constraint);
    }

    public void addVariable(Variable variable) {
        this.getMip().add(variable);
    }

    @Override
    public SRVMMipResult calculateAllocation() {
        IMIPResult mipResult = SOLVER.solve((IMIP)this.getMip());
        if (PRINT_SOLVER_RESULT) {
            logger.info("Result:\n" + mipResult);
        }
        SRVMMipResult.Builder resultBuilder = new SRVMMipResult.Builder(mipResult.getObjectiveValue(), this.world, mipResult);
        for (SRVMBidder bidder : this.bidderPartialMips.keySet()) {
            double unscaledValue = 0.0;
            for (SRVMBand band : this.world.getBands()) {
                Variable bidderVmVar = this.worldPartialMip.getVmVariable(bidder, (Band)band);
                double mipVmUtilityResult = mipResult.getValue(bidderVmVar);
                Variable bidderVoVar = this.worldPartialMip.getVoVariable(bidder, (Band)band);
                double mipVoUtilityResult = mipResult.getValue(bidderVoVar);
                double value = (double)bidder.getInterbandSynergyValue().floatValue() * mipVmUtilityResult + mipVoUtilityResult;
                unscaledValue = value * this.worldPartialMip.getScalingFactor();
            }
            GenericValue.Builder valueBuilder = new GenericValue.Builder(BigDecimal.valueOf(unscaledValue));
            for (SRVMBand band : this.world.getBands()) {
                Variable xVar = this.worldPartialMip.getXVariable(bidder, (Band)band);
                double doubleQuantity = mipResult.getValue(xVar);
                int quantity = (int)Math.round(doubleQuantity);
                valueBuilder.putQuantity((GenericDefinition)band, quantity);
            }
            resultBuilder.putGenericValue((Bidder<?>)bidder, valueBuilder.build());
        }
        return resultBuilder.build();
    }

    public SRVMWorldPartialMip getWorldPartialMip() {
        return this.worldPartialMip;
    }

    public Map<SRVMBidder, SRVMBidderPartialMIP> getBidderPartialMips() {
        return this.bidderPartialMips;
    }
}

