/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.domain;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.bidlang.xor.XORBid;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.vcg.external.domain.Bids;

public final class Auction<T extends Good> {
    private final Bids<T> bids;
    private final Set<T> goods;

    public Auction(Bids<T> bids, Set<T> goods) {
        this.bids = bids;
        this.goods = ImmutableSet.copyOf(goods);
    }

    public Set<Bidder<T>> getBidders() {
        return this.bids.getBidders();
    }

    public Collection<XORBid<T>> getBidCollection() {
        return this.bids.getBids();
    }

    public Bids<T> getBids() {
        return this.bids;
    }

    public Auction<T> without(Bidder<T> bidder) {
        return new Auction<T>(this.bids.without(bidder), this.goods);
    }

    public Set<T> getGoods() {
        return Collections.unmodifiableSet(this.goods);
    }

    public XORBid<T> getBid(Bidder<T> bidder) {
        return this.bids.getBid(bidder);
    }

    public Auction<T> withLowBidsRemoved(double goodReservePrice) {
        ArrayList newBids = new ArrayList();
        for (Bidder<T> bidder : this.getBidders()) {
            XORBid<T> bid = this.getBid(bidder);
            Set filteredBundleBids = bid.getValues().stream().filter(bb -> bb.value().compareTo(new BigDecimal((double)bb.getLicenses().size() * goodReservePrice, MathContext.DECIMAL64)) >= 0).collect(Collectors.toSet());
            XORBid newBid = new XORBid.Builder(bidder, filteredBundleBids).build();
            newBids.add(newBid);
        }
        Bids newAuctionBids = new Bids(newBids);
        return new Auction(newAuctionBids, this.goods);
    }
}

