/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.vcg;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnequalWorldsException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.opt.model.Allocation;

public final class ItemAllocation<T extends Good>
implements Allocation<Bundle<T>> {
    private final World world;
    private final Map<Bidder<T>, Bundle<T>> alloc;
    private final BigDecimal totalValue;

    private ItemAllocation(ItemAllocationBuilder<T> builder) {
        this.world = ((ItemAllocationBuilder)builder).world;
        this.alloc = ((ItemAllocationBuilder)builder).alloc;
        this.totalValue = ((ItemAllocationBuilder)builder).totalValue;
    }

    @Override
    public Collection<Bidder<T>> getBidders() {
        return this.alloc.keySet();
    }

    @Override
    public Bundle<T> getAllocation(Bidder<?> bidder) {
        Bundle<T> candidate = this.alloc.get(bidder);
        if (candidate == null) {
            if (bidder.getWorld().equals((Object)this.world)) {
                return new Bundle();
            }
            throw new UnequalWorldsException("BidderWorldId: " + bidder.getWorldId() + " AllocationWorldId: " + this.world.getId());
        }
        return candidate;
    }

    @Override
    public BigDecimal getTotalValue() {
        return this.totalValue;
    }

    public static final class ItemAllocationBuilder<T extends Good> {
        private World world;
        private Map<Bidder<T>, Bundle<T>> alloc;
        private BigDecimal totalValue;

        public ItemAllocationBuilder<T> withWorld(World world) {
            this.setWorld(world);
            return this;
        }

        public ItemAllocationBuilder<T> withAllocation(Map<Bidder<T>, Bundle<T>> alloc) {
            this.setAlloc(alloc);
            return this;
        }

        public ItemAllocationBuilder<T> withTotalValue(BigDecimal totalValue) {
            this.setTotalValue(totalValue);
            return this;
        }

        public ItemAllocation<T> build() {
            return new ItemAllocation(this);
        }

        private void setWorld(World world) {
            this.world = world;
        }

        private void setAlloc(Map<Bidder<T>, Bundle<T>> alloc) {
            this.alloc = alloc;
        }

        private void setTotalValue(BigDecimal totalValue) {
            this.totalValue = totalValue;
        }
    }
}

