/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidfile;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.spectrumauctions.sats.core.bidfile.FileWriter;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericLang;
import org.spectrumauctions.sats.core.bidlang.xor.XORLanguage;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Good;

public class CatsExporter
extends FileWriter {
    public CatsExporter(File path) {
        super(path);
    }

    @Override
    public File writeSingleBidderXOR(XORLanguage<? extends Good> valueFunction, int numberOfBids, String filePrefix) throws IOException {
        Iterator<XORValue<? extends Good>> iter = valueFunction.iterator();
        HashSet<XORValue<? extends Good>> selectedValues = new HashSet<XORValue<? extends Good>>();
        List<String> bidLines = this.fileInit(valueFunction);
        for (int i = 0; i < numberOfBids && iter.hasNext(); ++i) {
            XORValue<? extends Good> value = iter.next();
            selectedValues.add(value);
            String line = String.valueOf(i).concat("\t");
            line = line.concat(this.roundedValue(value.value().doubleValue()));
            line = line.concat("\t");
            line = line.concat(value.getLicenses().itemIds("\t")).concat("#");
            bidLines.add(line);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("goods " + valueFunction.getBidder().getWorld().getNumberOfGoods());
        lines.add("bids " + selectedValues.size());
        lines.add("dummy 0");
        lines.add("");
        lines.addAll(bidLines);
        return this.write(lines, filePrefix);
    }

    private List<String> fileInit(XORLanguage<? extends Good> lang) {
        ArrayList<String> lines = new ArrayList<String>();
        String satsversion = null;
        try {
            satsversion = this.getClass().getPackage().getImplementationVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (satsversion == null) {
            satsversion = "(UNKNOWN VERSION)";
        }
        lines.add("%% File generated by SATS  ".concat(satsversion).concat("  on  ").concat(new Date().toString()));
        lines.add("");
        lines.add("%% The SATS webpage is http://spectrumauctions.org");
        lines.add("");
        return lines;
    }

    @Override
    public File writeMultiBidderXOR(Collection<XORLanguage<? extends Good>> valueFunctions, int numberOfBids, String filePrefix) throws IOException {
        List<String> lines = this.fileInit(valueFunctions.iterator().next());
        lines.add("%% This file may contain bids from multiple bidders.");
        lines.add("% Bids from different bidders are separated using dummy items with negative IDs");
        lines.add("");
        lines.add("");
        ArrayList<String> bidLines = new ArrayList<String>();
        int dummyItem = -1;
        int countBids = 0;
        for (XORLanguage<? extends Good> valueFunction : valueFunctions) {
            Iterator<XORValue<? extends Good>> iter = valueFunction.iterator();
            for (int i = 0; i < numberOfBids && iter.hasNext(); ++i) {
                XORValue<? extends Good> value = iter.next();
                StringBuilder line = new StringBuilder(String.valueOf(countBids++)).append("\t");
                line.append(this.roundedValue(value.value().doubleValue()));
                line.append("\t");
                line.append(value.getLicenses().itemIds("\t"));
                line.append("\t");
                line.append(dummyItem);
                line.append("\t#");
                bidLines.add(line.toString());
            }
            --dummyItem;
        }
        lines.add("goods " + valueFunctions.iterator().next().getBidder().getWorld().getNumberOfGoods());
        lines.add("bids " + bidLines.size());
        lines.add("dummy " + valueFunctions.size());
        lines.add("");
        lines.addAll(bidLines);
        return this.write(lines, filePrefix);
    }

    private File write(List<String> lines, String filePrefix) throws IOException {
        Path file = this.nextNonexistingFile(filePrefix);
        Files.write(file, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        return file.toFile();
    }

    @Override
    public File writeMultiBidderXORQ(Collection<GenericLang<GenericDefinition>> valueFunctions, int numberOfBids, String filePrefix) throws IOException {
        throw new UnsupportedOperationException("XOR-Q is not compatible with the CATS file format");
    }

    @Override
    public File writeSingleBidderXORQ(GenericLang<GenericDefinition> lang, int numberOfBids, String filePrefix) throws IOException {
        throw new UnsupportedOperationException("XOR-Q is not compatible with the CATS file format");
    }

    @Override
    protected String filetype() {
        return "txt";
    }
}

