/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowerset;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericSetsPickN;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public abstract class GenericPowersetDecreasing<T extends GenericDefinition>
extends GenericPowerset<T> {
    GenericPowersetDecreasing(Map<T, Integer> maxQuantities, int maxBundleSize) throws UnsupportedBiddingLanguageException {
        super(maxQuantities, maxBundleSize);
    }

    protected GenericPowersetDecreasing(List<T> genericDefinitions) throws UnsupportedBiddingLanguageException {
        super(genericDefinitions);
    }

    @Override
    protected void isFeasibleSize(Map<T, Integer> maxQuantities, int maxBundleSize) throws UnsupportedBiddingLanguageException {
        if (maxQuantities.size() > 15) {
            throw new UnsupportedBiddingLanguageException("GenericPowersetDecreasing is not suitable for big model instances");
        }
    }

    @Override
    public Iterator<GenericValue<T>> iterator() {
        return new DecreasingIterator();
    }

    private class DecreasingIterator
    extends GenericPowerset.PowersetIterator {
        public DecreasingIterator() {
            this.bundleSize = GenericPowersetDecreasing.this.maxBundleSize;
            this.intiPickN();
        }

        @Override
        public boolean hasNext() {
            return this.pickN.hasNext() || this.bundleSize >= 1;
        }

        @Override
        void intiPickN() {
            this.pickN = new GenericSetsPickN(GenericPowersetDecreasing.this.maxQuantities, this.bundleSize--);
        }
    }
}

