/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import java.util.List;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public abstract class DefaultModel<W extends World, B extends Bidder<? extends Good>> {
    public abstract W createWorld(RNGSupplier var1);

    public W createWorld(long seed) {
        return this.createWorld(new JavaUtilRNGSupplier(seed));
    }

    public W createWorld() {
        return this.createWorld(new JavaUtilRNGSupplier());
    }

    public abstract List<B> createPopulation(W var1, RNGSupplier var2);

    public List<B> createNewPopulation() {
        return this.createNewPopulation(new JavaUtilRNGSupplier());
    }

    public List<B> createNewPopulation(long seed) {
        return this.createNewPopulation(new JavaUtilRNGSupplier(seed));
    }

    public List<B> createNewPopulation(RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        JavaUtilRNGSupplier worldSupplier = new JavaUtilRNGSupplier(rng.nextLong());
        JavaUtilRNGSupplier populationSupplier = new JavaUtilRNGSupplier(rng.nextLong());
        return this.createNewPopulation(worldSupplier, populationSupplier);
    }

    public List<B> createNewPopulation(long worldSeed, long populationSeed) {
        return this.createNewPopulation(new JavaUtilRNGSupplier(worldSeed), new JavaUtilRNGSupplier(populationSeed));
    }

    public List<B> createNewPopulation(RNGSupplier worldRNG, RNGSupplier populationRNG) {
        W world = this.createWorld(worldRNG);
        return this.createPopulation(world, populationRNG);
    }

    public List<B> createPopulation(W world, long populationSeed) {
        return this.createPopulation(world, new JavaUtilRNGSupplier(populationSeed));
    }

    public List<B> createPopulation(W world) {
        return this.createPopulation(world, new JavaUtilRNGSupplier());
    }
}

