/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm.mbvm;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.DefaultModel;
import org.spectrumauctions.sats.core.model.bvm.BMBidder;
import org.spectrumauctions.sats.core.model.bvm.BMBidderSetup;
import org.spectrumauctions.sats.core.model.bvm.BMWorld;
import org.spectrumauctions.sats.core.model.bvm.mbvm.MBVMBidderSetup;
import org.spectrumauctions.sats.core.model.bvm.mbvm.MBVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class MultiBandValueModel
extends DefaultModel<BMWorld, BMBidder> {
    MBVMWorldSetup.MBVMWorldSetupBuilder worldSetupBuilder = new MBVMWorldSetup.MBVMWorldSetupBuilder("DEFAULT_MULTIBAND_VALUE_MODEL_WORLD_SETUP");
    MBVMBidderSetup.MBVMBidderSetupBuilder bidderSetupBuilder;

    public MultiBandValueModel() {
        this(5);
    }

    public MultiBandValueModel(int numberOfBidders) {
        this.bidderSetupBuilder = new MBVMBidderSetup.MBVMBidderSetupBuilder("DEFAULT_MULTIBAND_VALUE_MODEL_BIDDER_SETUP", numberOfBidders);
    }

    @Override
    public BMWorld createWorld(RNGSupplier rngSupplier) {
        return new BMWorld(this.worldSetupBuilder.build(), rngSupplier);
    }

    @Override
    public List<BMBidder> createPopulation(BMWorld world, RNGSupplier populationRNG) {
        ArrayList<BMBidderSetup> setupset = new ArrayList<BMBidderSetup>();
        setupset.add(this.bidderSetupBuilder.build());
        return world.createPopulation(setupset, populationRNG);
    }

    public int getNumberOfBidders() {
        return this.bidderSetupBuilder.getNumberOfBidders();
    }

    public void setNumberOfBidders(int numberOfBidders) {
        Preconditions.checkArgument((numberOfBidders > 0 ? 1 : 0) != 0);
        this.bidderSetupBuilder.setNumberOfBidders(numberOfBidders);
    }

    protected void modifyWorldBuilder() {
        this.worldSetupBuilder.setSetupName("MODIFIED_MBVM");
    }

    protected void modifyBidderBuilder() {
        this.bidderSetupBuilder.setSetupName("MODIFIED_MBVM");
    }
}

