/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class MRVMLocalBidderSetup
extends MRVMBidderSetup {
    private final IntegerInterval numberOfRegionsInterval;
    private final List<String> regionNotes;

    protected MRVMLocalBidderSetup(Builder builder) {
        super(builder);
        this.numberOfRegionsInterval = builder.numberOfRegionsInterval;
        this.regionNotes = builder.regionNotes;
    }

    public Set<MRVMRegionsMap.Region> drawRegionsOfInterest(MRVMWorld world, UniformDistributionRNG rng) {
        if (this.regionNotes == null) {
            return this.drawRegionsOfInterestRandomly(world, rng);
        }
        return this.pickPredeterminedRegions(world);
    }

    private Set<MRVMRegionsMap.Region> pickPredeterminedRegions(MRVMWorld world) {
        HashSet<MRVMRegionsMap.Region> result = new HashSet<MRVMRegionsMap.Region>();
        Preconditions.checkNotNull(this.regionNotes, (Object)"This method must only be called if there are predefined regions");
        Preconditions.checkArgument((!this.regionNotes.isEmpty() ? 1 : 0) != 0, (Object)"This message must only be called if there are predefined regions");
        for (String desiredRegionNote : this.regionNotes) {
            for (MRVMRegionsMap.Region region : world.getRegionsMap().getRegions()) {
                if (!region.getNote().equals(desiredRegionNote)) continue;
                result.add(region);
            }
        }
        return result;
    }

    private Set<MRVMRegionsMap.Region> drawRegionsOfInterestRandomly(MRVMWorld world, UniformDistributionRNG rng) {
        int numberOfRegions = rng.nextInt(this.numberOfRegionsInterval);
        if (numberOfRegions > world.getRegionsMap().getRegions().size()) {
            numberOfRegions = world.getRegionsMap().getRegions().size();
        }
        List<MRVMRegionsMap.Region> regions = new ArrayList<MRVMRegionsMap.Region>(world.getRegionsMap().getRegions());
        Collections.shuffle(regions, new Random(rng.nextLong()));
        regions = regions.subList(0, numberOfRegions);
        return new HashSet<MRVMRegionsMap.Region>(regions);
    }

    public static class Builder
    extends MRVMBidderSetup.Builder {
        private IntegerInterval numberOfRegionsInterval = new IntegerInterval(3, 7);
        private List<String> regionNotes;

        public Builder() {
            super("Multi Region Model Local Bidder", 3, new DoubleInterval(60.0, 100.0), new DoubleInterval(0.05, 0.12));
        }

        public void setPredefinedRegionsOfInterest(List<String> regionNotes) {
            Preconditions.checkArgument((regionNotes == null || !regionNotes.isEmpty() ? 1 : 0) != 0, (Object)"List of RegionNotes must not be empty");
            this.regionNotes = regionNotes;
        }

        public void setNumberOfRegionsInterval(IntegerInterval numberOfRegionsInterval) {
            this.numberOfRegionsInterval = numberOfRegionsInterval;
            this.setPredefinedRegionsOfInterest(null);
        }

        @Override
        public MRVMLocalBidderSetup build() {
            return new MRVMLocalBidderSetup(this);
        }
    }
}

