/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class MRVMRegionalBidderSetup
extends MRVMBidderSetup {
    private final double exponentFactor;
    private final double base;

    protected MRVMRegionalBidderSetup(Builder builder) {
        super(builder);
        this.exponentFactor = builder.exponentFactor;
        this.base = builder.base;
    }

    public MRVMRegionsMap.Region drawHome(MRVMWorld world, UniformDistributionRNG rng) {
        ArrayList<MRVMRegionsMap.Region> regions = new ArrayList<MRVMRegionsMap.Region>(world.getRegionsMap().getRegions());
        int index = rng.nextInt(regions.size());
        return (MRVMRegionsMap.Region)regions.get(index);
    }

    public ImmutableSortedMap<Integer, BigDecimal> drawDistanceDiscounts(MRVMWorld world, MRVMRegionsMap.Region home, UniformDistributionRNG rng) {
        ImmutableSortedMap.Builder distanceDiscount = ImmutableSortedMap.naturalOrder();
        distanceDiscount.put((Object)0, (Object)BigDecimal.ONE);
        int maxDistance = world.getRegionsMap().getLongestShortestPath(home);
        for (int i = 1; i <= maxDistance; ++i) {
            double exponent = this.exponentFactor * (double)i * -1.0;
            double gamma = Math.pow(this.base, exponent);
            Preconditions.checkState((gamma >= 0.0 && gamma <= 1.0 ? 1 : 0) != 0, (Object)"Invalid Gamma, some of the calculation parameters have unallowed values");
            BigDecimal roundedGamma = BigDecimal.valueOf(gamma).setScale(5, 5);
            distanceDiscount.put((Object)i, (Object)roundedGamma);
        }
        return distanceDiscount.build();
    }

    public static class Builder
    extends MRVMBidderSetup.Builder {
        private double exponentFactor = 1.25;
        private double base = 2.0;

        public Builder() {
            super("Multi Region Model Regional Bidder", 4, new DoubleInterval(500.0, 840.0), new DoubleInterval(0.04, 0.1));
        }

        public void setGammaShape(double base, double exponentFactor) {
            Preconditions.checkArgument((base > 0.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((exponentFactor > 0.0 ? 1 : 0) != 0);
            this.base = base;
            this.exponentFactor = exponentFactor;
        }

        public double getExponentFactor() {
            return this.exponentFactor;
        }

        public double getBase() {
            return this.base;
        }

        @Override
        public MRVMRegionalBidderSetup build() {
            return new MRVMRegionalBidderSetup(this);
        }
    }
}

