/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLocalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLocalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class MRVMWorld
extends World {
    private static final int BIGDECIMAL_PRECISON = 10;
    private static final long serialVersionUID = 2189142937399997527L;
    public static final String MODEL_NAME = "Multi-Region Value Model";
    private final MRVMRegionsMap regionsMap;
    private final HashSet<MRVMBand> bands;
    private transient BigDecimal maximalRegionalCapacity = null;

    public MRVMWorld(MRVMWorldSetup worldSetup, RNGSupplier rngSupplier) {
        super(MODEL_NAME);
        this.regionsMap = new MRVMRegionsMap(worldSetup, rngSupplier);
        this.bands = MRVMBand.createBands(this, worldSetup, this.regionsMap, rngSupplier.getUniformDistributionRNG());
        this.store();
    }

    @Override
    public int getNumberOfGoods() {
        int numberOfLicenses = 0;
        for (MRVMBand band : this.bands) {
            int numberOfRegions = this.regionsMap.getRegions().size();
            int numberOfLots = band.getNumberOfLots();
            numberOfLicenses += numberOfLots * numberOfRegions;
        }
        return numberOfLicenses;
    }

    public Set<MRVMBand> getBands() {
        return Collections.unmodifiableSet(this.bands);
    }

    public Set<MRVMLicense> getLicenses() {
        HashSet<MRVMLicense> licenses = new HashSet<MRVMLicense>();
        for (MRVMBand band : this.bands) {
            licenses.addAll(band.getLicenses());
        }
        return licenses;
    }

    public Collection<? extends Bidder<MRVMLicense>> restorePopulation(long populationId) {
        return super.restorePopulation(MRVMBidder.class, populationId);
    }

    @Override
    public void refreshFieldBackReferences() {
        for (MRVMBand band : this.bands) {
            band.refreshFieldBackReferences(this);
        }
    }

    public MRVMRegionsMap getRegionsMap() {
        return this.regionsMap;
    }

    public static Map<MRVMBand, Bundle<MRVMLicense>> getLicensesPerBand(Bundle<MRVMLicense> bundle) {
        Preconditions.checkArgument((!bundle.isEmpty() ? 1 : 0) != 0);
        MRVMWorld world = ((MRVMLicense)bundle.iterator().next()).getWorld();
        return MRVMWorld.getLicensesPerBand(bundle, world);
    }

    public static Map<MRVMBand, Bundle<MRVMLicense>> getLicensesPerBand(Bundle<MRVMLicense> bundle, MRVMWorld world) {
        HashMap<MRVMBand, Bundle<MRVMLicense>> licensesPerBand = new HashMap<MRVMBand, Bundle<MRVMLicense>>();
        for (MRVMBand band : world.getBands()) {
            licensesPerBand.put(band, new Bundle());
        }
        for (MRVMLicense license : bundle) {
            ((Bundle)licensesPerBand.get(license.getBand())).add(license);
        }
        return licensesPerBand;
    }

    public static Map<MRVMBand, Integer> quantitiesPerBand(Bundle<MRVMLicense> bundle) {
        Preconditions.checkArgument((boolean)bundle.isEmpty());
        return MRVMWorld.quantitiesPerBand(bundle, (MRVMWorld)bundle.getWorld());
    }

    public static Map<MRVMBand, Integer> quantitiesPerBand(Bundle<MRVMLicense> bundle, MRVMWorld MRVMWorld2) {
        Map<MRVMBand, Bundle<MRVMLicense>> licensesPerBand = MRVMWorld.getLicensesPerBand(bundle, MRVMWorld2);
        HashMap<MRVMBand, Integer> quantities = new HashMap<MRVMBand, Integer>();
        for (MRVMBand band : MRVMWorld2.getBands()) {
            try {
                quantities.put(band, licensesPerBand.get(band).size());
            }
            catch (NullPointerException e) {
                quantities.put(band, 0);
            }
        }
        return quantities;
    }

    public static BigDecimal c(MRVMRegionsMap.Region r, Bundle<MRVMLicense> bundle) {
        if (bundle.isEmpty()) {
            return BigDecimal.ZERO;
        }
        Bundle<MRVMLicense> regionalSubBundle = MRVMWorld.getLicensesPerRegion(bundle).get(r);
        Map<MRVMBand, Integer> bandQuantities = MRVMWorld.quantitiesPerBand(regionalSubBundle, (MRVMWorld)bundle.getWorld());
        BigDecimal cap = BigDecimal.ZERO;
        for (Map.Entry<MRVMBand, Integer> bandQuantityEntry : bandQuantities.entrySet()) {
            if (bandQuantityEntry.getValue() == 0) continue;
            BigDecimal bandCap = MRVMWorld.capOfBand(bandQuantityEntry.getKey(), bandQuantityEntry.getValue());
            cap = cap.add(bandCap);
        }
        return cap;
    }

    public BigDecimal getMaximumRegionalCapacity() {
        if (this.maximalRegionalCapacity == null) {
            MRVMRegionsMap.Region anyRegion = this.regionsMap.getRegions().iterator().next();
            this.maximalRegionalCapacity = MRVMWorld.c(anyRegion, new Bundle<MRVMLicense>((Collection<MRVMLicense>)this.getLicenses()));
        }
        return this.maximalRegionalCapacity;
    }

    public static BigDecimal capOfBand(MRVMBand band, int numberOfLicenses) {
        if (numberOfLicenses == 0) {
            return BigDecimal.ZERO;
        }
        Preconditions.checkArgument((numberOfLicenses >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((numberOfLicenses <= band.getNumberOfLots() ? 1 : 0) != 0);
        BigDecimal quantity = new BigDecimal(numberOfLicenses);
        BigDecimal baseCapacity = band.getBaseCapacity();
        BigDecimal synergy = band.getSynergy(numberOfLicenses);
        BigDecimal bandCap = quantity.multiply(baseCapacity).multiply(synergy);
        return bandCap;
    }

    public static Map<MRVMRegionsMap.Region, Bundle<MRVMLicense>> getLicensesPerRegion(Bundle<MRVMLicense> bundle) {
        Preconditions.checkArgument((!bundle.isEmpty() ? 1 : 0) != 0);
        MRVMWorld world = ((MRVMLicense)bundle.iterator().next()).getWorld();
        HashMap<MRVMRegionsMap.Region, Bundle<MRVMLicense>> licensesPerRegion = new HashMap<MRVMRegionsMap.Region, Bundle<MRVMLicense>>();
        for (MRVMRegionsMap.Region region : world.getRegionsMap().getRegions()) {
            licensesPerRegion.put(region, new Bundle());
        }
        for (MRVMLicense license : bundle) {
            ((Bundle)licensesPerRegion.get(license.getRegion())).add(license);
        }
        return licensesPerRegion;
    }

    public List<MRVMBidder> createPopulation(MRVMLocalBidderSetup localSetup, MRVMRegionalBidderSetup regionalSetup, MRVMNationalBidderSetup nationalSetup, RNGSupplier rngSupplier) {
        HashSet<MRVMLocalBidderSetup> localSetups = null;
        HashSet<MRVMRegionalBidderSetup> regionalSetups = null;
        HashSet<MRVMNationalBidderSetup> nationalSetups = null;
        if (localSetup != null) {
            localSetups = new HashSet<MRVMLocalBidderSetup>();
            localSetups.add(localSetup);
        }
        if (regionalSetup != null) {
            regionalSetups = new HashSet<MRVMRegionalBidderSetup>();
            regionalSetups.add(regionalSetup);
        }
        if (nationalSetup != null) {
            nationalSetups = new HashSet<MRVMNationalBidderSetup>();
            nationalSetups.add(nationalSetup);
        }
        return this.createPopulation(localSetups, regionalSetups, nationalSetups, rngSupplier);
    }

    public List<MRVMBidder> createPopulation(Collection<MRVMLocalBidderSetup> localSetups, Collection<MRVMRegionalBidderSetup> regionalSetups, Collection<MRVMNationalBidderSetup> nationalSetups, RNGSupplier rngSupplier) {
        int i;
        long population = this.openNewPopulation();
        ArrayList<MRVMBidder> bidders = new ArrayList<MRVMBidder>();
        int idCount = 0;
        if (localSetups != null) {
            for (MRVMLocalBidderSetup mRVMLocalBidderSetup : localSetups) {
                for (i = 0; i < mRVMLocalBidderSetup.getNumberOfBidders(); ++i) {
                    bidders.add(new MRVMLocalBidder((long)idCount++, population, this, mRVMLocalBidderSetup, rngSupplier.getUniformDistributionRNG()));
                }
            }
        }
        if (regionalSetups != null) {
            for (MRVMRegionalBidderSetup mRVMRegionalBidderSetup : regionalSetups) {
                for (i = 0; i < mRVMRegionalBidderSetup.getNumberOfBidders(); ++i) {
                    bidders.add(new MRVMRegionalBidder((long)idCount++, population, this, mRVMRegionalBidderSetup, rngSupplier.getUniformDistributionRNG()));
                }
            }
        }
        if (nationalSetups != null) {
            for (MRVMNationalBidderSetup mRVMNationalBidderSetup : nationalSetups) {
                for (i = 0; i < mRVMNationalBidderSetup.getNumberOfBidders(); ++i) {
                    bidders.add(new MRVMNationalBidder((long)idCount++, population, this, mRVMNationalBidderSetup, rngSupplier.getUniformDistributionRNG()));
                }
            }
        }
        Preconditions.checkArgument((bidders.size() > 0 ? 1 : 0) != 0, (Object)"At least one bidder setup with a strictly positive number of bidders is required to generate population");
        return bidders;
    }
}

