/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.Band;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class SRVMBand
extends Band
implements GenericDefinition {
    private static final long serialVersionUID = 8297467604786037769L;
    private final List<SRVMLicense> licenses;
    private final long worldId;
    private transient SRVMWorld world;

    static Set<SRVMBand> createBands(SRVMWorld world, SRVMWorldSetup setup, RNGSupplier rngSupplier) {
        HashSet<SRVMBand> bands = new HashSet<SRVMBand>();
        int startId = 0;
        for (Map.Entry<String, Integer> bandDefinition : setup.defineBands(rngSupplier).entrySet()) {
            bands.add(new SRVMBand(bandDefinition.getKey(), world, bandDefinition.getValue(), startId));
            startId += bandDefinition.getValue().intValue();
        }
        Preconditions.checkArgument((bands.size() != 0 ? 1 : 0) != 0, (Object)"WorldSetup has to define at least one band");
        return bands;
    }

    private SRVMBand(String name, SRVMWorld world, int numberOfLicenses, int startId) {
        super(name);
        this.world = world;
        this.worldId = world.getId();
        ArrayList<SRVMLicense> builder = new ArrayList<SRVMLicense>();
        for (int i = 0; i < numberOfLicenses; ++i) {
            builder.add(new SRVMLicense((long)startId++, this));
        }
        this.licenses = Collections.unmodifiableList(builder);
    }

    public SRVMWorld getWorld() {
        return this.world;
    }

    public List<SRVMLicense> getLicenses() {
        return Collections.unmodifiableList(this.licenses);
    }

    @Override
    public String getName() {
        return this.name;
    }

    void refreshFieldBackReferences(SRVMWorld world) {
        Preconditions.checkArgument((world.getId() == this.worldId ? 1 : 0) != 0);
        this.world = world;
        for (SRVMLicense license : this.licenses) {
            license.refreshFieldBackReferences(this);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.licenses == null ? 0 : this.licenses.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SRVMBand other = (SRVMBand)obj;
        if (this.licenses == null ? other.licenses != null : !this.licenses.equals(other.licenses)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int getNumberOfLicenses() {
        return this.licenses.size();
    }

    @Override
    public boolean isPartOf(Good license) {
        if (license == null) {
            return false;
        }
        if (!(license instanceof SRVMLicense)) {
            return false;
        }
        SRVMLicense SRVMLicense2 = (SRVMLicense)license;
        return SRVMLicense2.getBand().equals(this);
    }

    @Override
    public int numberOfLicenses() {
        return this.licenses.size();
    }

    public Set<SRVMLicense> allLicenses() {
        return new HashSet<SRVMLicense>(this.licenses);
    }

    @Override
    public JsonElement shortJson() {
        JsonObject json = new JsonObject();
        json.addProperty("band", this.getName());
        return json;
    }
}

