/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.base.Preconditions;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;

public final class SRVMLicense
extends Good {
    private static final long serialVersionUID = 7672703280459172931L;
    private final String bandName;
    private transient SRVMBand band;

    SRVMLicense(long id, SRVMBand band) {
        super(id, band.getWorld().getId());
        this.band = band;
        this.bandName = band.getName();
    }

    public SRVMBand getBand() {
        return this.band;
    }

    @Override
    public SRVMWorld getWorld() {
        return this.band.getWorld();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bandName == null ? 0 : this.bandName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SRVMLicense other = (SRVMLicense)obj;
        return !(this.bandName == null ? other.bandName != null : !this.bandName.equals(other.bandName));
    }

    void refreshFieldBackReferences(SRVMBand band) {
        Preconditions.checkArgument((boolean)band.getName().equals(this.bandName));
        this.band = band;
    }
}

