/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.lsvm;

import com.google.common.collect.ImmutableSet;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidder;
import org.spectrumauctions.sats.core.model.lsvm.LSVMGrid;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.opt.model.EfficientAllocator;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.lsvm.LSVMGridGraph;
import org.spectrumauctions.sats.opt.vcg.external.vcg.ItemAllocation;

public class LSVMStandardMIP
extends ModelMIP
implements EfficientAllocator<ItemAllocation<LSVMLicense>> {
    private int n;
    private int m;
    private double[][] v;
    private Map<Long, LSVMBidder> bidderMap;
    private Map<Long, LSVMLicense> licenseMap;
    private LSVMWorld world;
    private Variable[][][] A;
    private Variable[][][] E;
    private Edge[] edges;
    private Map<Edge, Set<Integer>> validPathLengths = new HashMap<Edge, Set<Integer>>();

    public LSVMStandardMIP(LSVMWorld world, List<LSVMBidder> population) {
        this.world = world;
        this.bidderMap = population.stream().collect(Collectors.toMap(b -> b.getId(), Function.identity()));
        this.licenseMap = world.getLicenses().stream().collect(Collectors.toMap(l -> l.getId(), Function.identity()));
        this.m = world.getLicenses().size();
        this.n = population.size();
        this.v = new double[this.n][this.m];
        this.A = new Variable[this.n][this.m][this.m];
        int numberOfEdges = this.m * (this.m - 1) / 2;
        this.E = new Variable[this.n][numberOfEdges][this.m];
        this.edges = new Edge[numberOfEdges];
        this.getMip().setObjectiveMax(true);
        this.getMip().setSolveParam(SolveParam.TIME_LIMIT, (Object)3600.0);
        this.initBaseValues();
        this.initA();
        this.initEdge();
        this.initE();
        this.buildObjectiveTerm();
        this.buildSupplyEvalConstraints();
        this.buildEdgeSupplyConstraints();
        this.buildNeighbourConstraints();
        this.buildEdgeConstraints();
        this.buildTauConstraints();
    }

    @Override
    public ItemAllocation<LSVMLicense> calculateAllocation() {
        SolverClient solver = new SolverClient();
        IMIPResult result = solver.solve((IMIP)this.getMip());
        HashMap allocation = new HashMap();
        for (int i = 0; i < this.n; ++i) {
            Bundle<Good> bundle = new Bundle<Good>();
            for (int j = 0; j < this.m; ++j) {
                for (int t = 0; t < this.m; ++t) {
                    if (!(result.getValue(this.A[i][j][t]) > 0.0)) continue;
                    bundle.add(this.licenseMap.get(j));
                }
            }
            allocation.put(this.bidderMap.get(i), bundle);
        }
        ItemAllocation.ItemAllocationBuilder builder = new ItemAllocation.ItemAllocationBuilder().withWorld(this.world).withTotalValue(BigDecimal.valueOf(result.getObjectiveValue())).withAllocation(allocation);
        return builder.build();
    }

    private void buildObjectiveTerm() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                for (int t = 0; t < this.m; ++t) {
                    double value = this.calculateComplementarityMarkup(t + 1, this.bidderMap.get(i)) * this.v[i][j];
                    this.getMip().addObjectiveTerm(value, this.A[i][j][t]);
                }
            }
        }
    }

    private void buildSupplyEvalConstraints() {
        for (int j = 0; j < this.m; ++j) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
            for (int i = 0; i < this.n; ++i) {
                for (int t = 0; t < this.m; ++t) {
                    constraint.addTerm(1.0, this.A[i][j][t]);
                }
            }
            this.getMip().add(constraint);
        }
    }

    private void buildEdgeSupplyConstraints() {
        for (int e = 0; e < this.edges.length; ++e) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
            for (int i = 0; i < this.n; ++i) {
                for (int c = 0; c < this.m; ++c) {
                    if (!this.isValidPathLength(this.edges[e], c + 1)) continue;
                    constraint.addTerm(1.0, this.E[i][e][c]);
                }
            }
            this.getMip().add(constraint);
        }
    }

    private void buildNeighbourConstraints() {
        for (int i = 0; i < this.n; ++i) {
            for (int e = 0; e < this.edges.length; ++e) {
                for (int c = 1; c < this.m; ++c) {
                    if (!this.isValidPathLength(this.edges[e], c + 1)) continue;
                    Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                    constraint.addTerm(-1.0, this.E[i][e][c]);
                    for (int x : this.n(this.gMin(this.edges[e]))) {
                        int ne;
                        int y;
                        if (x == (y = this.gMax(this.edges[e]).intValue()) || !this.isValidPathLength(this.edges[ne = this.fInv(x, y).intValue()], c)) continue;
                        constraint.addTerm(1.0, this.E[i][ne][c - 1]);
                    }
                    this.getMip().add(constraint);
                }
            }
        }
    }

    private void buildEdgeConstraints() {
        for (int i = 0; i < this.n; ++i) {
            for (int e = 0; e < this.edges.length; ++e) {
                Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                for (int c = 0; c < this.m; ++c) {
                    if (!this.isValidPathLength(this.edges[e], c + 1)) continue;
                    constraint.addTerm(-2.0, this.E[i][e][c]);
                }
                for (int j : this.f(this.edges[e])) {
                    for (int t = 0; t < this.m; ++t) {
                        constraint.addTerm(1.0, this.A[i][j][t]);
                    }
                }
                this.getMip().add(constraint);
            }
        }
    }

    private void buildTauConstraints() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
                for (int t = 0; t < this.m; ++t) {
                    constraint.addTerm((double)(t + 1), this.A[i][j][t]);
                }
                for (int x = 0; x < this.m; ++x) {
                    if (x == j) continue;
                    for (int c = 0; c < this.m; ++c) {
                        int e = this.fInv(x, j);
                        if (!this.isValidPathLength(this.edges[e], c + 1)) continue;
                        constraint.addTerm(-1.0, this.E[i][e][c]);
                    }
                }
                this.getMip().add(constraint);
            }
        }
    }

    private void initBaseValues() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                this.v[i][j] = this.bidderMap.get(i).getBaseValues().getOrDefault(j, new BigDecimal(0.0)).doubleValue();
            }
        }
    }

    private void initA() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                for (int t = 0; t < this.m; ++t) {
                    this.A[i][j][t] = new Variable(String.format("A_i[%d]j[%d]t[%d]", i, j, t), VarType.BOOLEAN, 0.0, 1.0);
                    this.getMip().add(this.A[i][j][t]);
                }
            }
        }
    }

    private void initEdge() {
        int index = 0;
        for (int x = 0; x < this.m; ++x) {
            for (int y = x + 1; y < this.m; ++y) {
                this.edges[index] = new Edge(this.licenseMap.get(x), this.licenseMap.get(y));
                this.buildValidPathLength(this.edges[index]);
                ++index;
            }
        }
    }

    private void buildValidPathLength(Edge edge) {
        LSVMGridGraph grid = new LSVMGridGraph(this.world.getGrid());
        Set<Set<Vertex>> allPaths = grid.findAllPaths(grid.getVertex(edge.l1), grid.getVertex(edge.l2));
        List sizeOrderedPaths = allPaths.stream().sorted((a1, a2) -> Integer.compare(a1.size(), a2.size())).collect(Collectors.toList());
        ArrayList<Set> solution = new ArrayList<Set>();
        for (Set current : sizeOrderedPaths) {
            if (solution.stream().filter(sol -> current.containsAll((Collection<?>)sol)).count() != 0L) continue;
            solution.add(current);
        }
        Set valid = solution.stream().map(path -> path.size() - 1).collect(Collectors.toSet());
        this.validPathLengths.put(edge, valid);
    }

    private void initE() {
        for (int i = 0; i < this.n; ++i) {
            for (int e = 0; e < this.edges.length; ++e) {
                for (int c = 0; c < this.m; ++c) {
                    if (!this.isValidPathLength(this.edges[e], c + 1)) continue;
                    this.E[i][e][c] = new Variable(String.format("E_i[%d]e[%d]c[%d]", i, e, c), VarType.BOOLEAN, 0.0, 1.0);
                    this.getMip().add(this.E[i][e][c]);
                }
            }
        }
    }

    private boolean isValidPathLength(Edge edge, int pathLength) {
        return this.validPathLengths.get(edge).contains(pathLength);
    }

    private double calculateComplementarityMarkup(int tau, LSVMBidder bidder) {
        if (tau < 1) {
            throw new IllegalArgumentException("Error: tau has to be >=1");
        }
        return bidder.calculateFactor(tau);
    }

    private Integer gMin(Edge e) {
        int neighbourCountL2;
        int l1 = (int)e.l1.getId();
        int l2 = (int)e.l2.getId();
        int neighbourCountL1 = this.n(l1).size();
        if (neighbourCountL1 < (neighbourCountL2 = this.n(l2).size())) {
            return l1;
        }
        if (neighbourCountL1 > neighbourCountL2) {
            return l2;
        }
        return Math.min(l1, l2);
    }

    private Integer gMax(Edge e) {
        Set<Integer> immutableSet = this.f(e);
        Integer minLicense = this.gMin(e);
        Set mutableSet = immutableSet.stream().filter(l -> l != minLicense).collect(Collectors.toSet());
        assert (mutableSet.size() == 1);
        return (Integer)mutableSet.iterator().next();
    }

    private Set<Integer> n(Integer j) {
        LSVMGrid grid = this.world.getGrid();
        LSVMLicense jLicense = this.licenseMap.get(j);
        return this.licenseMap.values().stream().filter(x -> grid.isNeighbor((LSVMLicense)x, jLicense)).map(x -> (int)x.getId()).collect(Collectors.toSet());
    }

    private Set<Integer> f(Edge e) {
        return ImmutableSet.of((Object)((int)e.l1.getId()), (Object)((int)e.l2.getId()));
    }

    private Integer fInv(Integer l1, Integer l2) {
        for (int e = 0; e < this.edges.length; ++e) {
            Edge edge = this.edges[e];
            Integer el1 = (int)edge.l1.getId();
            Integer el2 = (int)edge.l2.getId();
            if ((el1 != l1 || el2 != l2) && (el1 != l2 || el2 != l1)) continue;
            return e;
        }
        throw new IllegalStateException("Error: fInv edge not found");
    }

    public class Edge {
        LSVMLicense l1;
        LSVMLicense l2;

        public Edge(LSVMLicense l1, LSVMLicense l2) {
            this.l1 = l1;
            this.l2 = l2;
        }
    }
}

