/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm;

import edu.harvard.econcs.jopt.solver.IMIPResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.opt.model.GenericAllocation;

public final class MRVMMipResult
extends GenericAllocation<MRVMGenericDefinition> {
    private final MRVMWorld world;
    private final BigDecimal totalValue;
    private final IMIPResult joptResult;

    private MRVMMipResult(Builder builder) {
        super(builder);
        this.world = builder.world;
        this.totalValue = BigDecimal.valueOf(builder.objectiveValue);
        this.joptResult = builder.joptResult;
    }

    @Override
    public BigDecimal getTotalValue() {
        return this.totalValue;
    }

    public IMIPResult getJoptResult() {
        return this.joptResult;
    }

    public MRVMWorld getWorld() {
        return this.world;
    }

    public String toString() {
        String tab = "\t";
        StringBuilder builder = new StringBuilder();
        ArrayList sortedEntries = new ArrayList(this.values.entrySet());
        Collections.sort(sortedEntries, (e1, e2) -> Long.valueOf(((Bidder)e1.getKey()).getId()).compareTo(((Bidder)e2.getKey()).getId()));
        builder.append("===== bidder listing =======").append(System.lineSeparator());
        for (Map.Entry entry : sortedEntries) {
            MRVMBidder bidder = (MRVMBidder)entry.getKey();
            builder.append(((Bidder)entry.getKey()).getId()).append(tab).append(((Bidder)entry.getKey()).getClass().getSimpleName()).append("(").append(bidder.getSetupType()).append(")").append(tab).append(((GenericValue)entry.getValue()).getValue().toString()).append(" #licenses:").append(((GenericValue)entry.getValue()).getTotalQuantity()).append(System.lineSeparator());
        }
        builder.append("===== allocation table =======").append(System.lineSeparator());
        if (!this.values.isEmpty()) {
            MRVMWorld world = (MRVMWorld)((Bidder)this.values.keySet().iterator().next()).getWorld();
            ArrayList<MRVMBand> orderedBands = new ArrayList<MRVMBand>(world.getBands());
            Collections.sort(orderedBands, (b1, b2) -> Integer.valueOf(b1.getName().length()).compareTo(b2.getName().length()));
            for (MRVMBand band : orderedBands) {
                builder.append(tab).append(band.getName());
            }
            builder.append(System.lineSeparator());
            for (MRVMRegionsMap.Region region : world.getRegionsMap().getRegions()) {
                builder.append("rid").append(region.getId()).append(tab).append("(").append(region.getNote()).append(", population: ").append(region.getPopulation()).append(")").append(System.lineSeparator());
                for (Map.Entry entry : sortedEntries) {
                    builder.append(tab);
                    for (MRVMBand band : orderedBands) {
                        MRVMGenericDefinition def = new MRVMGenericDefinition(band, region);
                        int quantity = ((GenericValue)entry.getValue()).getQuantity(def);
                        builder.append(quantity).append(tab).append(tab).append(tab);
                    }
                    MRVMBidder bidder = (MRVMBidder)entry.getKey();
                    builder.append(((Bidder)entry.getKey()).getClass().getSimpleName()).append(((Bidder)entry.getKey()).getId()).append(" (").append(bidder.getSetupType()).append(")");
                    builder.append(System.lineSeparator());
                }
                builder.append("----------------newregion----------------").append(System.lineSeparator());
            }
        }
        return builder.toString();
    }

    public static final class Builder
    extends GenericAllocation.Builder<MRVMGenericDefinition> {
        private MRVMWorld world;
        private double objectiveValue;
        private final IMIPResult joptResult;

        public Builder(double objectiveValue, MRVMWorld world, IMIPResult joptResult) {
            this.objectiveValue = objectiveValue;
            this.world = world;
            this.joptResult = joptResult;
        }

        public MRVMMipResult build() {
            return new MRVMMipResult(this);
        }
    }
}

