/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.srvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.Band;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.opt.imip.PartialMIP;
import org.spectrumauctions.sats.opt.model.srvm.SRVMBidderPartialMIP;

public class SRVMWorldPartialMip
extends PartialMIP {
    public static final String xVariablePrefix = "X";
    public static final String vmVariablePrefix = "VM";
    public static final String voVariablePrefix = "VO";
    private final Map<SRVMBidder, Map<Band, Variable>> xVariables;
    private final Map<SRVMBidder, Map<Band, Variable>> vmVariables;
    private final Map<SRVMBidder, Map<Band, Variable>> voVariables;
    private final double biggestPossibleValue;
    private final Set<SRVMBidder> bidders;
    private final SRVMWorld world;
    private final double scalingFactor;

    SRVMWorldPartialMip(Collection<SRVMBidder> bidders2, double biggestPossibleValue, double scalingFactor) {
        Preconditions.checkNotNull(bidders2);
        Preconditions.checkArgument((bidders2.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((biggestPossibleValue <= 5.3687091E8 ? 1 : 0) != 0);
        this.biggestPossibleValue = biggestPossibleValue;
        this.scalingFactor = scalingFactor;
        this.bidders = Collections.unmodifiableSet(new HashSet<SRVMBidder>(bidders2));
        this.world = bidders2.iterator().next().getWorld();
        Preconditions.checkNotNull((Object)this.world);
        this.xVariables = this.initXVariables();
        this.vmVariables = this.initValueVariables(vmVariablePrefix);
        this.voVariables = this.initValueVariables(voVariablePrefix);
    }

    private Set<Constraint> createNumberOfLotsConstraints() {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (SRVMBand band : this.world.getBands()) {
            Constraint numberOfLotsConstraint = new Constraint(CompareType.LEQ, (double)band.getNumberOfLicenses());
            for (SRVMBidder bidder : this.bidders) {
                Variable xVar = this.getXVariable(bidder, band);
                numberOfLotsConstraint.addTerm(1.0, xVar);
            }
            result.add(numberOfLotsConstraint);
        }
        return result;
    }

    private Map<SRVMBidder, Map<Band, Variable>> initValueVariables(String prefix) {
        HashMap result = new HashMap();
        for (SRVMBidder bidder : this.bidders) {
            HashMap<SRVMBand, Variable> temp = new HashMap<SRVMBand, Variable>();
            for (SRVMBand band : this.world.getBands()) {
                String varName = prefix + "_" + bidder.getId() + "_" + band.getName();
                Variable var = new Variable(varName, VarType.DOUBLE, 0.0, 5.3687091E8);
                temp.put(band, var);
            }
            result.put(bidder, temp);
        }
        return Collections.unmodifiableMap(result);
    }

    private Map<SRVMBidder, Map<Band, Variable>> initXVariables() {
        HashMap result = new HashMap();
        for (SRVMBidder bidder : this.bidders) {
            HashMap<SRVMBand, Variable> bandMap = new HashMap<SRVMBand, Variable>();
            for (SRVMBand band : this.world.getBands()) {
                String varName = xVariablePrefix.concat(SRVMBidderPartialMIP.createIndex(bidder, band));
                Variable var = new Variable(varName, VarType.INT, 0.0, (double)band.getNumberOfLicenses());
                bandMap.put(band, var);
            }
            result.put(bidder, Collections.unmodifiableMap(bandMap));
        }
        return Collections.unmodifiableMap(result);
    }

    private void appendObjectiveToMip(MIP mip) {
        mip.setObjectiveMax(true);
        if (mip.getLinearObjectiveTerms() != null && mip.getQuadraticObjectiveTerms() != null || mip.getObjectiveTerms().size() != 0) {
            // empty if block
        }
        for (SRVMBidder bidder : this.bidders) {
            double syni = bidder.getInterbandSynergyValue().floatValue();
            for (SRVMBand band : this.world.getBands()) {
                mip.addObjectiveTerm(syni, this.vmVariables.get(bidder).get(band));
                mip.addObjectiveTerm(1.0, this.voVariables.get(bidder).get(band));
            }
        }
    }

    @Override
    public void appendToMip(MIP mip) {
        super.appendToMip(mip);
        this.appendObjectiveToMip(mip);
    }

    @Override
    public void appendConstraintsToMip(MIP mip) {
        super.appendConstraintsToMip(mip);
        for (Constraint c : this.createNumberOfLotsConstraints()) {
            mip.add(c);
        }
    }

    @Override
    public void appendVariablesToMip(MIP mip) {
        super.appendVariablesToMip(mip);
        for (Map.Entry<SRVMBidder, Map<Band, Variable>> entry : this.vmVariables.entrySet()) {
            for (Map.Entry<Band, Variable> bandVariableEntry : entry.getValue().entrySet()) {
                mip.add(bandVariableEntry.getValue());
            }
        }
        for (Map.Entry<SRVMBidder, Map<Band, Variable>> entry : this.voVariables.entrySet()) {
            for (Map.Entry<Band, Variable> bandVariableEntry : entry.getValue().entrySet()) {
                mip.add(bandVariableEntry.getValue());
            }
        }
        for (Map map : this.xVariables.values()) {
            for (Variable var : map.values()) {
                mip.add(var);
            }
        }
    }

    public Variable getXVariable(SRVMBidder bidder, Band band) {
        Variable var = this.xVariables.get(bidder).get(band);
        if (var == null) {
            throw new NullPointerException();
        }
        return var;
    }

    public Variable getVmVariable(SRVMBidder bidder, Band band) {
        Variable var = this.vmVariables.get(bidder).get(band);
        if (var == null) {
            throw new NullPointerException();
        }
        return var;
    }

    public Variable getVoVariable(SRVMBidder bidder, Band band) {
        Variable var = this.voVariables.get(bidder).get(band);
        if (var == null) {
            throw new NullPointerException();
        }
        return var;
    }

    public double getBiggestPossibleValue() {
        return this.biggestPossibleValue;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }
}

