/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.xor.XORBid;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnequalWorldsException;
import org.spectrumauctions.sats.core.model.World;

public class Bids<T extends Good>
implements Iterable<XORBid<T>> {
    private final Map<Bidder<T>, XORBid<T>> bids = new HashMap<Bidder<T>, XORBid<T>>();

    public Bids() {
    }

    public Bids(Collection<XORBid<T>> bids) {
        this();
        for (XORBid<T> bid : bids) {
            this.bids.put(bid.getBidder(), bid);
        }
    }

    public Map<Bidder<T>, XORBid<T>> getBidMap() {
        return Collections.unmodifiableMap(this.bids);
    }

    public boolean addBid(XORBid<T> bid) {
        this.validate(bid);
        return this.bids.put(bid.getBidder(), bid) == null;
    }

    private void validate(XORBid<T> bid) {
        if (!this.bids.isEmpty() && !this.bids.keySet().iterator().next().getWorld().equals(bid.getBidder().getWorld())) {
            throw new UnequalWorldsException();
        }
    }

    private void validateAll() {
        World world = null;
        for (Bidder<T> bidder : this.bids.keySet()) {
            if (world == null) {
                world = bidder.getWorld();
                continue;
            }
            if (world.equals(bidder.getWorld())) continue;
            throw new UnequalWorldsException();
        }
    }

    @Override
    public Iterator<XORBid<T>> iterator() {
        return this.bids.values().iterator();
    }

    public Set<Bidder<T>> getBidders() {
        return this.bids.keySet();
    }

    public Collection<XORBid<T>> getBids() {
        return this.bids.values();
    }

    public Bids<T> without(Bidder<T> bidder) {
        HashMap<Bidder<T>, XORBid<T>> newBidderBidMap = new HashMap<Bidder<T>, XORBid<T>>(this.bids);
        newBidderBidMap.remove(bidder);
        return new Bids<T>(newBidderBidMap.values());
    }

    public XORBid<T> getBid(Bidder<T> bidder) {
        return this.bids.get(bidder);
    }

    public boolean contains(Bidder<T> bidder) {
        return this.bids.containsKey(bidder);
    }
}

