/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.domain;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.model.Allocation;
import org.spectrumauctions.sats.opt.vcg.external.domain.BidderAllocation;

public class XORAllocation<T extends Good>
implements Allocation<BidderAllocation<T>> {
    private final double totalValue;
    private final Map<Bidder<T>, BidderAllocation<T>> trades;

    public XORAllocation(Map<Bidder<T>, BidderAllocation<T>> trades) {
        double totalValue = 0.0;
        for (BidderAllocation<T> allocation : trades.values()) {
            totalValue += allocation.getTradeValue();
        }
        this.totalValue = totalValue;
        this.trades = trades;
    }

    public double getTotalAllocationValue() {
        return this.totalValue;
    }

    public Collection<BidderAllocation<T>> getTrades() {
        return this.trades.values();
    }

    public Map<Bidder<T>, BidderAllocation<T>> getTradesMap() {
        return this.trades;
    }

    public boolean isWinner(Bidder bidder) {
        return this.trades.containsKey(bidder);
    }

    @Deprecated
    public BidderAllocation tradeOf(Bidder bidder) {
        return this.trades.get(bidder);
    }

    public Set<Bidder<T>> getWinners() {
        return this.trades.keySet();
    }

    public String toString() {
        return "Allocation[trades=" + this.trades + "]";
    }

    @Override
    public Collection<? extends Bidder<?>> getBidders() {
        return this.trades.keySet();
    }

    @Override
    public BidderAllocation<T> getAllocation(Bidder<?> bidder) {
        BidderAllocation<T> result = this.trades.get(bidder);
        if (result == null) {
            return new BidderAllocation(0.0, new Bundle<Good>(), new HashSet());
        }
        return result;
    }

    @Override
    public BigDecimal getTotalValue() {
        return BigDecimal.valueOf(this.totalValue);
    }
}

