/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.vcg;

import java.util.HashMap;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.model.Allocation;
import org.spectrumauctions.sats.opt.vcg.external.domain.Auction;
import org.spectrumauctions.sats.opt.vcg.external.domain.AuctionResult;
import org.spectrumauctions.sats.opt.vcg.external.domain.BidderAllocation;
import org.spectrumauctions.sats.opt.vcg.external.domain.BidderPayment;
import org.spectrumauctions.sats.opt.vcg.external.domain.Payment;
import org.spectrumauctions.sats.opt.vcg.external.domain.XORAllocation;
import org.spectrumauctions.sats.opt.vcg.external.domain.mechanisms.AuctionMechanism;
import org.spectrumauctions.sats.opt.vcg.external.winnerdetermination.WinnerDetermination;

public abstract class VCGAuction<T extends Good>
implements AuctionMechanism {
    private AuctionResult<T> result;
    private Auction<T> auction;

    public VCGAuction(Auction<T> auction) {
        this.auction = auction;
    }

    @Override
    public AuctionResult<T> getAuctionResult() {
        if (this.result == null) {
            this.result = this.calculateVCGPrices(this.auction);
        }
        return this.result;
    }

    @Override
    public Payment<T> getPayment() {
        return this.getAuctionResult().getPayment();
    }

    public XORAllocation<T> calculateAllocation() {
        return this.getAuctionResult().getAllocation();
    }

    protected AuctionResult<T> calculateVCGPrices(Auction<T> auction) {
        WinnerDetermination baseWD = this.getWinnerDetermination(auction);
        Allocation baseAllocation = baseWD.calculateAllocation();
        HashMap payments = new HashMap();
        for (Bidder bidder : ((XORAllocation)baseAllocation).getWinners()) {
            double valueWithoutBidder = ((XORAllocation)baseAllocation).getTotalAllocationValue() - ((BidderAllocation)((XORAllocation)baseAllocation).getAllocation(bidder)).getTradeValue();
            Auction<T> auctionWithoutBidder = auction.without(bidder);
            WinnerDetermination wdWithoutBidder = this.getWinnerDetermination(auctionWithoutBidder);
            Allocation allocationWithoutBidder = wdWithoutBidder.calculateAllocation();
            double valueWDWithoutBidder = ((XORAllocation)allocationWithoutBidder).getTotalAllocationValue();
            double paymentAmount = valueWDWithoutBidder - valueWithoutBidder;
            payments.put(bidder, new BidderPayment(paymentAmount));
        }
        Payment payment = new Payment(payments);
        return new AuctionResult(payment, baseAllocation);
    }

    protected abstract WinnerDetermination getWinnerDetermination(Auction<T> var1);
}

