/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.winnerdetermination;

import com.google.common.collect.ImmutableSet;
import com.google.common.math.DoubleMath;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.Collection;
import java.util.HashMap;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.model.EfficientAllocator;
import org.spectrumauctions.sats.opt.vcg.external.domain.Auction;
import org.spectrumauctions.sats.opt.vcg.external.domain.BidderAllocation;
import org.spectrumauctions.sats.opt.vcg.external.domain.XORAllocation;

public abstract class WinnerDetermination<T extends Good>
implements EfficientAllocator<XORAllocation<T>> {
    private XORAllocation<T> result = null;
    private Auction<T> auction;

    public WinnerDetermination(Auction<T> auction) {
        this.auction = auction;
    }

    protected abstract IMIP getMIP();

    @Override
    public XORAllocation<T> calculateAllocation() {
        if (this.result == null) {
            this.result = this.solveWinnerDetermination();
        }
        return this.result;
    }

    protected Auction<T> getAuction() {
        return this.auction;
    }

    private XORAllocation<T> solveWinnerDetermination() {
        SolverClient solver = new SolverClient();
        IMIPResult mipResult = solver.solve(this.getMIP());
        return this.adaptMIPResult(mipResult);
    }

    protected abstract Variable getBidVariable(XORValue<T> var1);

    protected XORAllocation<T> adaptMIPResult(IMIPResult mipResult) {
        HashMap trades = new HashMap();
        for (Bidder<T> bidder : this.auction.getBidders()) {
            double totalValue = 0.0;
            ImmutableSet.Builder goodsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder bundleBids = ImmutableSet.builder();
            for (XORValue<T> bundleBid : this.auction.getBid(bidder).getValues()) {
                if (!DoubleMath.fuzzyEquals((double)mipResult.getValue(this.getBidVariable(bundleBid)), (double)1.0, (double)0.001)) continue;
                goodsBuilder.addAll(bundleBid.getLicenses());
                bundleBids.add(bundleBid);
                totalValue += bundleBid.value().doubleValue();
            }
            ImmutableSet goods = goodsBuilder.build();
            if (goods.isEmpty()) continue;
            trades.put(bidder, new BidderAllocation(totalValue, new Bundle<Good>((Collection<Good>)goods), bundleBids.build()));
        }
        return new XORAllocation(trades);
    }
}

