/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.clt;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.spectrumauctions.sats.clt.Model;
import org.spectrumauctions.sats.clt.ModelOptionParser;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public class CommandLineTool {
    public static String KEY_HELP = "help";

    public static void main(String[] args) throws IOException {
        Model model;
        OptionParser helpFirstParser = new OptionParser();
        helpFirstParser.accepts("help");
        helpFirstParser.accepts("model").withRequiredArg().ofType(Model.class);
        helpFirstParser.allowsUnrecognizedOptions();
        OptionSet helpFirstOptions = helpFirstParser.parse(args);
        if (helpFirstOptions.has("help") && !helpFirstOptions.has("model")) {
            ModelOptionParser.printGeneralHelp();
            return;
        }
        OptionParser modelDiscovery = new OptionParser();
        modelDiscovery.accepts("model").withRequiredArg().ofType(Model.class).required();
        modelDiscovery.allowsUnrecognizedOptions();
        try {
            OptionSet modelOption = modelDiscovery.parse(args);
            model = (Model)((Object)modelOption.valueOf("model"));
        }
        catch (OptionException e) {
            e.printStackTrace();
            ModelOptionParser.printGeneralHelp();
            return;
        }
        ModelOptionParser modelParser = ModelOptionParser.createOptionParser(model);
        try {
            PathResult pathResult = modelParser.treatResult(args);
            if (pathResult != null) {
                CommandLineTool.printSuccess(args, pathResult);
            }
        }
        catch (IllegalConfigException e) {
            e.printStackTrace();
        }
        catch (UnsupportedBiddingLanguageException e) {
            String message = e.getMessage();
            System.out.print("The chosen bidding language (iterator and/or XOR/XOR-Q) cannot be used for the chosen model    ");
            if (message != null) {
                System.out.println(message);
            } else {
                System.out.println();
            }
            e.printStackTrace();
        }
    }

    private static void printSuccess(String[] args, PathResult pathResult) {
        OptionParser checkMuted = new OptionParser();
        checkMuted.accepts(ModelOptionParser.KEY_MUTE);
        checkMuted.allowsUnrecognizedOptions();
        if (!checkMuted.parse(args).has(ModelOptionParser.KEY_MUTE)) {
            String satsversion = null;
            try {
                satsversion = CommandLineTool.class.getPackage().getImplementationVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (satsversion == null) {
                satsversion = "(UNKNOWN VERSION)";
            }
            System.out.println("Successfully created value files with: " + satsversion);
            System.out.println("Bids can be found in the following files");
            for (File file : pathResult.getValueFiles()) {
                System.out.println("\t - " + file.getPath());
            }
            if (pathResult.isAreInstancesSerialized()) {
                System.out.println("The serialized instances can be found here:");
                System.out.println("\t - " + pathResult.getInstanceFolder().getPath());
            }
        }
    }

    public static boolean printHelpIfRequested(OptionSet generalOptions, Model model, OptionParser toPrint) {
        if (generalOptions.has("help")) {
            CommandLineTool.printHelp(String.valueOf((Object)model), toPrint);
            return true;
        }
        return false;
    }

    public static void printHelp(String modelName, OptionParser toPrint) {
        System.out.println();
        System.out.println("==== Options applicable for " + modelName + "====");
        try {
            toPrint.printHelpOn((OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

