/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.api;

import java.io.File;
import java.io.IOException;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.ModelCreator;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.bvm.bvm.BaseValueModel;

public final class BVMModelCreator
extends ModelCreator {
    private final int numberOfBidders;

    public BVMModelCreator(Builder builder) {
        super(builder);
        this.numberOfBidders = builder.numberOfBidders;
    }

    @Override
    public PathResult generateResult(File outputFolder) throws UnsupportedBiddingLanguageException, IOException, IllegalConfigException {
        BaseValueModel model = new BaseValueModel();
        model.setNumberOfBidders(this.numberOfBidders);
        return this.appendTopLevelParamsAndSolve(model, outputFolder);
    }

    public static final class Builder
    extends ModelCreator.Builder {
        public int numberOfBidders = new BaseValueModel().getNumberOfBidders();

        @Override
        public BVMModelCreator build() {
            return new BVMModelCreator(this);
        }

        public int getNumberOfBidders() {
            return this.numberOfBidders;
        }

        public void setNumberOfBidders(int numberOfBidders) {
            this.numberOfBidders = numberOfBidders;
        }
    }
}

