/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeOrdered;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public abstract class GenericSizeIncreasing<T extends GenericDefinition<S>, S extends Good>
extends GenericSizeOrdered<T, S> {
    protected GenericSizeIncreasing(Collection<T> allPossibleGenericDefintions) throws UnsupportedBiddingLanguageException {
        super(allPossibleGenericDefintions);
    }

    @Override
    public Iterator<GenericValue<T, S>> iterator() {
        return new IncreasingIterator();
    }

    private class IncreasingIterator
    implements Iterator<GenericValue<T, S>> {
        int round = 0;
        private Iterator<Set<T>> definitionPowersetIterator;
        private Map<T, Integer> roundSize;
        private boolean hasNext;

        protected IncreasingIterator() {
            this.initNextRound();
        }

        private void initNextRound() {
            this.roundSize = new HashMap();
            Iterator iterator = GenericSizeIncreasing.this.allDefintions.iterator();
            while (iterator.hasNext()) {
                int quantity = this.round;
                GenericDefinition def = (GenericDefinition)iterator.next();
                if (quantity > def.numberOfLicenses()) {
                    quantity = def.numberOfLicenses();
                }
                this.roundSize.put(def, quantity);
            }
            ++this.round;
            this.initPowersetIterator();
        }

        private void initPowersetIterator() {
            HashSet<GenericDefinition> leftOverQuantities = new HashSet<GenericDefinition>();
            for (GenericDefinition def : GenericSizeIncreasing.this.allDefintions) {
                if (this.roundSize.get(def) >= def.numberOfLicenses()) continue;
                leftOverQuantities.add(def);
            }
            if (leftOverQuantities.size() == 0) {
                this.hasNext = false;
                return;
            }
            this.hasNext = true;
            Set definitionPowerset = Sets.powerSet(leftOverQuantities);
            ArrayList sorted = new ArrayList(definitionPowerset);
            sorted.sort(GenericSizeIncreasing.this.getIncreasingSizeComparator());
            this.definitionPowersetIterator = sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public GenericValue<T, S> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            GenericValue.Builder val = new GenericValue.Builder(GenericSizeIncreasing.this.getGenericBidder());
            Set toAdd = this.definitionPowersetIterator.next();
            for (GenericDefinition def : GenericSizeIncreasing.this.allDefintions) {
                int quantity = this.roundSize.get(def);
                if (toAdd.contains(def)) {
                    ++quantity;
                }
                val.putQuantity(def, quantity);
            }
            if (!this.definitionPowersetIterator.hasNext()) {
                this.initNextRound();
            }
            return val.build();
        }
    }
}

