/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericLang;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public abstract class XORQRandomOrderSimple<T extends GenericDefinition<S>, S extends Good>
implements GenericLang<T, S> {
    private static final double MAX_POSSIBLE_BIDS_FACTOR = 0.8;
    private static final int ABSOLUTE_MAX_BIDS = 1000000;
    private static final int DEFAULT_ITERATIONS = 500;
    private final Map<T, Integer> maxQuantities;
    private final int maxBundleSize;
    private final RNGSupplier rngSupplier;
    private final transient long seed;
    private final transient int totalSize;
    private final transient Set<GenericValue> cache;
    private final transient int maxBids;
    private transient int iterations;

    protected XORQRandomOrderSimple(Collection<T> genericDefinitions, RNGSupplier rngSupplier) {
        this.rngSupplier = rngSupplier;
        this.seed = this.rngSupplier.getUniformDistributionRNG().nextLong();
        LinkedHashMap<GenericDefinition, Integer> orderedMap = new LinkedHashMap<GenericDefinition, Integer>();
        int quantitySum = 0;
        for (GenericDefinition def : genericDefinitions) {
            quantitySum += def.numberOfLicenses();
            orderedMap.put(def, def.numberOfLicenses());
        }
        this.maxQuantities = Collections.unmodifiableMap(orderedMap);
        this.maxBundleSize = quantitySum;
        this.totalSize = quantitySum;
        this.iterations = 500;
        this.maxBids = this.setMaxBid(this.maxQuantities);
        this.cache = new HashSet<GenericValue>();
    }

    private int setMaxBid(Map<T, Integer> maxQuantities) {
        int maxBids = 1;
        for (int i : maxQuantities.values()) {
            if (Math.abs(maxBids) > 1000000) break;
            maxBids *= i;
        }
        return maxBids;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public Iterator<GenericValue<T, S>> iterator() {
        return new SimpleRandomOrderIterator(this.iterations, this.rngSupplier.getUniformDistributionRNG(this.seed));
    }

    protected abstract GenericValueBidder<T> getGenericBidder();

    protected abstract Comparator<T> getDefComparator();

    class SimpleRandomOrderIterator
    implements Iterator<GenericValue<T, S>> {
        private final UniformDistributionRNG uniRng;
        private int remainingIterations;

        SimpleRandomOrderIterator(int iterations, UniformDistributionRNG uniRng) {
            this.remainingIterations = iterations;
            this.uniRng = uniRng;
        }

        @Override
        public boolean hasNext() {
            return this.remainingIterations > 0 && (double)XORQRandomOrderSimple.this.cache.size() < 0.8 * (double)XORQRandomOrderSimple.this.maxBids;
        }

        @Override
        public GenericValue<T, S> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map quantities = this.getRandomQuantities();
            GenericValue.Builder genValBuilder = new GenericValue.Builder(XORQRandomOrderSimple.this.getGenericBidder());
            for (Map.Entry entry : quantities.entrySet()) {
                genValBuilder.putQuantity((GenericDefinition)entry.getKey(), entry.getValue());
            }
            GenericValue result = genValBuilder.build();
            if (!XORQRandomOrderSimple.this.cache.contains(result)) {
                XORQRandomOrderSimple.this.cache.add(result);
                --this.remainingIterations;
                return result;
            }
            return this.next();
        }

        private Map<T, Integer> getRandomQuantities() {
            HashMap quantities = new HashMap();
            for (Map.Entry good : XORQRandomOrderSimple.this.maxQuantities.entrySet()) {
                if (!this.includeGood((Integer)good.getValue(), XORQRandomOrderSimple.this.totalSize, XORQRandomOrderSimple.this.maxQuantities.size())) continue;
                int quantity = this.uniRng.nextInt(1, (Integer)good.getValue());
                quantities.put(good.getKey(), quantity);
            }
            return quantities;
        }

        private boolean includeGood(int quantity, int totalQuantity, int numberOfGoods) {
            double base = 1.0 / (double)numberOfGoods;
            double bonus = 1.0 / (double)totalQuantity * (double)quantity;
            return base + bonus >= this.uniRng.nextDouble();
        }
    }
}

