/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericSetsPickN;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;

public class XORQtoXOR<T extends Good>
implements Iterator<Bundle<T>> {
    private static final Logger logger = LogManager.getLogger(XORQtoXOR.class);
    private final ImmutableMap<GenericDefinition<T>, Integer> quantitites;
    private final ImmutableList<GenericDefinition<T>> orderOfDefs;
    List<GenericSetsPickN<T>> pickNiterators;
    List<List<T>> currentSets;

    XORQtoXOR(Map<? extends GenericDefinition<T>, Integer> quantitites) {
        ImmutableMap.Builder nonZeroQuantitiesBuilder = new ImmutableMap.Builder();
        ImmutableList.Builder orderBuilder = new ImmutableList.Builder();
        for (Map.Entry<GenericDefinition<T>, Integer> quantity : quantitites.entrySet()) {
            Preconditions.checkArgument((quantity.getValue() >= 0 ? 1 : 0) != 0, (String)"Quantity %s of generic definition %s is invalid", (Object[])new Object[]{quantity.getValue(), quantity.getKey()});
            if (quantity.getValue() <= 0) continue;
            nonZeroQuantitiesBuilder.put(quantity);
            orderBuilder.add(quantity.getKey());
        }
        this.quantitites = nonZeroQuantitiesBuilder.build();
        this.orderOfDefs = orderBuilder.build();
        Preconditions.checkArgument((this.orderOfDefs.size() != 0 ? 1 : 0) != 0, (Object)"Must define a strictly positive total quantity in the quantities map");
        this.currentSets = new ArrayList<List<T>>();
        this.pickNiterators = new ArrayList<GenericSetsPickN<T>>();
        for (int i = 0; i < this.orderOfDefs.size(); ++i) {
            this.pickNiterators.add(null);
            this.currentSets.add(null);
            this.resetIterator(i);
            if (i <= 0) continue;
            List<T> initialGoodSelection = this.quantityOneLicenses((Map<T, Integer>)this.pickNiterators.get(i).next());
            this.currentSets.set(i, initialGoodSelection);
        }
    }

    @Override
    public boolean hasNext() {
        for (GenericSetsPickN<T> pickNiter : this.pickNiterators) {
            if (!pickNiter.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Bundle<T> next() {
        for (int i = 0; i < this.pickNiterators.size(); ++i) {
            List<T> quantityOneLicenses;
            if (this.pickNiterators.get(i).hasNext()) {
                quantityOneLicenses = this.quantityOneLicenses((Map<T, Integer>)this.pickNiterators.get(i).next());
                this.currentSets.set(i, quantityOneLicenses);
                break;
            }
            if (i == this.pickNiterators.size() - 1) {
                throw new NoSuchElementException();
            }
            this.resetIterator(i);
            quantityOneLicenses = this.quantityOneLicenses((Map<T, Integer>)this.pickNiterators.get(i).next());
            this.currentSets.set(i, quantityOneLicenses);
        }
        Bundle bundle = new Bundle();
        for (Collection collection : this.currentSets) {
            bundle.addAll(collection);
        }
        return bundle;
    }

    private List<T> quantityOneLicenses(Map<T, Integer> quantities) {
        ArrayList<T> result = new ArrayList<T>();
        for (Map.Entry<T, Integer> entry : quantities.entrySet()) {
            if (entry.getValue() == 1) {
                result.add(entry.getKey());
                continue;
            }
            if (entry.getValue() == 0) continue;
            throw new IllegalArgumentException("All quantities must be either 0 or 1");
        }
        return result;
    }

    private void resetIterator(int iteratorNumber) {
        LinkedHashMap<Good, Integer> maxQuantities = new LinkedHashMap<Good, Integer>();
        if (iteratorNumber >= this.orderOfDefs.size()) {
            logger.info("abort");
        }
        for (Good good : ((GenericDefinition)this.orderOfDefs.get(iteratorNumber)).allLicenses()) {
            try {
                maxQuantities.put(good, 1);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Generic Definition License Type is different than the requested License Type");
            }
        }
        int bundleSize = (Integer)this.quantitites.get(this.orderOfDefs.get(iteratorNumber));
        GenericSetsPickN pickNIter = new GenericSetsPickN(maxQuantities, bundleSize);
        this.pickNiterators.set(iteratorNumber, pickNIter);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

