/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnequalWorldsException;

public final class XORBid<T extends Good> {
    private final Bidder<T> bidder;
    private final List<XORValue<T>> values;

    private XORBid(Builder<T> builder) {
        this.values = Collections.unmodifiableList(new ArrayList<T>(builder));
        this.bidder = ((Builder)builder).bidder;
        this.validate();
    }

    private void validate() {
        for (XORValue<T> value : this.values) {
            for (Good good : value.getLicenses()) {
                if (this.bidder.getWorld().equals(good.getWorld())) continue;
                throw new UnequalWorldsException("bidder and good are not from the same world");
            }
        }
    }

    public Bidder<T> getBidder() {
        return this.bidder;
    }

    public List<XORValue<T>> getValues() {
        return this.values;
    }

    public XORBid<T> copyOfWithNewValues(Collection<XORValue<T>> newValues) {
        ArrayList<XORValue<T>> newList = new ArrayList<XORValue<T>>(this.values);
        newList.addAll(newValues);
        return new XORBid<T>(new Builder<T>(this.bidder, newList));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XORBid xorBid = (XORBid)o;
        if (this.getBidder() != null ? !this.getBidder().equals(xorBid.getBidder()) : xorBid.getBidder() != null) {
            return false;
        }
        return this.getValues() != null ? this.getValues().equals(xorBid.getValues()) : xorBid.getValues() == null;
    }

    public int hashCode() {
        int result = this.getBidder() != null ? this.getBidder().hashCode() : 0;
        result = 31 * result + (this.getValues() != null ? this.getValues().hashCode() : 0);
        return result;
    }

    public static final class Builder<T extends Good>
    extends ArrayList<XORValue<T>> {
        private static final long serialVersionUID = -6540446139983915994L;
        private final Bidder<T> bidder;

        public Builder(Bidder<T> bidder) {
            this.bidder = bidder;
        }

        public XORValue<T> containsBundle(Bundle<T> bundle) {
            XORValue exists = null;
            for (XORValue xorValue : this) {
                if (!xorValue.getLicenses().equals(bundle)) continue;
                exists = xorValue;
                break;
            }
            return exists;
        }

        public Builder(Bidder<T> bidder, Collection<? extends XORValue<T>> values) {
            super(values);
            this.bidder = bidder;
        }

        public XORBid<T> build() {
            return new XORBid(this);
        }

        public void removeFromBid(XORValue<T> existing) {
            super.remove(existing);
        }
    }
}

