/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.Band;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.bvm.BMLicense;
import org.spectrumauctions.sats.core.model.bvm.BMWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class BMBand
extends Band
implements GenericDefinition<BMLicense>,
Serializable {
    private static final long serialVersionUID = 1156082993361102068L;
    private final List<BMLicense> licenses;
    private final long worldId;
    private transient BMWorld world;

    public BMBand(BMWorld world, String name, int numberOfLicenses, int licenseCounter, RNGSupplier rngSupplier) {
        super(name);
        this.world = world;
        this.worldId = world.getId();
        this.licenses = new ArrayList<BMLicense>();
        for (int i = 0; i < numberOfLicenses; ++i) {
            this.licenses.add(new BMLicense(licenseCounter++, this, rngSupplier));
        }
    }

    public BMWorld getWorld() {
        return this.world;
    }

    public Collection<BMLicense> getLicenses() {
        return Collections.unmodifiableCollection(this.licenses);
    }

    @Override
    public int getNumberOfLicenses() {
        return this.licenses.size();
    }

    public long getWorldId() {
        return this.worldId;
    }

    private void setWorld(BMWorld world) {
        if (this.getWorldId() != world.getId()) {
            throw new IncompatibleWorldException("The stored worldId does not represent the passed world reference");
        }
        this.world = world;
    }

    public void refreshFieldBackReferences(BMWorld world) {
        this.setWorld(world);
        for (BMLicense license : this.licenses) {
            license.refreshFieldBackReferences(this);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.licenses == null ? 0 : this.licenses.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BMBand other = (BMBand)obj;
        return !(this.licenses == null ? other.licenses != null : !this.licenses.equals(other.licenses));
    }

    @Override
    public boolean isPartOf(BMLicense license) {
        return license != null && license.getBand().equals(this);
    }

    @Override
    public int numberOfLicenses() {
        return this.getNumberOfLicenses();
    }

    @Override
    public Set<BMLicense> allLicenses() {
        return new HashSet<BMLicense>(this.getLicenses());
    }

    @Override
    public JsonElement shortJson() {
        JsonObject json = new JsonObject();
        json.addProperty("band", this.getName());
        return json;
    }
}

