/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.model.bvm.BMBidder;
import org.spectrumauctions.sats.core.model.bvm.BMLicense;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class RandomOrderXORQFactory
implements Serializable {
    private static final long serialVersionUID = 3752749595977909372L;
    static BandComparator comparator = new BandComparator();

    public static XORQRandomOrderSimple<BMBand, BMLicense> getXORQRandomOrderSimpleLang(BMBidder bidder, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        List<BMBand> bands = bidder.getWorld().getBands();
        return new SimpleRandomOrder(bands, bidder, rngSupplier);
    }

    public static XORQRandomOrderSimple<BMBand, BMLicense> getXORQRandomOrderSimpleLang(BMBidder bidder) throws UnsupportedBiddingLanguageException {
        List<BMBand> bands = bidder.getWorld().getBands();
        return new SimpleRandomOrder(bands, bidder, new JavaUtilRNGSupplier());
    }

    private static class BandComparator
    implements Comparator<BMBand>,
    Serializable {
        private static final long serialVersionUID = -1063512022491891006L;

        private BandComparator() {
        }

        @Override
        public int compare(BMBand o1, BMBand o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static final class SimpleRandomOrder
    extends XORQRandomOrderSimple<BMBand, BMLicense> {
        private final BMBidder bidder;

        SimpleRandomOrder(Collection<BMBand> allPossibleGenericDefinitions, BMBidder bidder, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefinitions, rngSupplier);
            this.bidder = bidder;
        }

        @Override
        public Bidder<? extends Good> getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<BMBand> getGenericBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<BMBand> getDefComparator() {
            return comparator;
        }
    }
}

