/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm.bvm;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.DefaultModel;
import org.spectrumauctions.sats.core.model.bvm.BMBidder;
import org.spectrumauctions.sats.core.model.bvm.BMBidderSetup;
import org.spectrumauctions.sats.core.model.bvm.BMWorld;
import org.spectrumauctions.sats.core.model.bvm.bvm.BVMBidderSetup;
import org.spectrumauctions.sats.core.model.bvm.bvm.BVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class BaseValueModel
extends DefaultModel<BMWorld, BMBidder> {
    BVMWorldSetup.BVMWorldSetupBuilder worldSetupBuilder = new BVMWorldSetup.BVMWorldSetupBuilder("DEFAULT_BASE_VALUE_MODEL_WORLD_SETUP");
    BVMBidderSetup.BVMBidderSetupBuilder bidderSetupBuilder;

    public BaseValueModel() {
        this(5);
    }

    public BaseValueModel(int numberOfBidders) {
        this.bidderSetupBuilder = new BVMBidderSetup.BVMBidderSetupBuilder("DEFAULT_BASE_VALUE_MODEL_BIDDER_SETUP", numberOfBidders);
    }

    @Override
    public BMWorld createWorld(RNGSupplier rngSupplier) {
        BVMWorldSetup setup = BVMWorldSetup.getDefaultSetup();
        return new BMWorld(setup, rngSupplier);
    }

    @Override
    public List<BMBidder> createPopulation(BMWorld world, RNGSupplier populationRNG) {
        ArrayList<BMBidderSetup> setupset = new ArrayList<BMBidderSetup>();
        setupset.add(this.bidderSetupBuilder.build());
        return world.createPopulation(setupset, populationRNG);
    }

    public int getNumberOfBidders() {
        return this.bidderSetupBuilder.getNumberOfBidders();
    }

    public void setNumberOfBidders(int numberOfBidders) {
        Preconditions.checkArgument((numberOfBidders > 0 ? 1 : 0) != 0);
        this.bidderSetupBuilder.setNumberOfBidders(numberOfBidders);
    }

    protected void modifyWorldBuilder() {
        this.worldSetupBuilder.setSetupName("MODIFIED_MBVM");
    }

    protected void modifyBidderBuilder() {
        this.bidderSetupBuilder.setSetupName("MODIFIED_MBVM");
    }
}

