/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.GenericLang;
import org.spectrumauctions.sats.core.bidlang.xor.CatsXOR;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.IncompatibleBiddingLanguageException;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.cats.CATSBidderSetup;
import org.spectrumauctions.sats.core.model.cats.CATSLicense;
import org.spectrumauctions.sats.core.model.cats.CATSWorld;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class CATSBidder
extends Bidder<CATSLicense> {
    private static final long serialVersionUID = -6762037404466323951L;
    private final HashMap<Long, BigDecimal> privateValues;
    private transient CATSWorld world;
    private transient ImmutableMap<Long, BigDecimal> privateValueMap;

    CATSBidder(CATSBidderSetup setup, CATSWorld world, long currentId, long population, RNGSupplier rngSupplier) {
        super(setup, population, currentId, world.getId());
        this.world = world;
        this.privateValues = setup.drawPrivateValues(rngSupplier, this);
        this.store();
    }

    @Override
    public BigDecimal calculateValue(Bundle<CATSLicense> bundle) {
        double value = 0.0;
        for (CATSLicense license : bundle) {
            if (!this.privateValues.containsKey(license.getId())) continue;
            value += license.getCommonValue();
            value += this.privateValues.get(license.getId()).doubleValue();
            if (!this.getWorld().getUseQuadraticPricingOption()) continue;
            value += Math.pow(license.getCommonValue(), 2.0);
        }
        if (!this.getWorld().getUseQuadraticPricingOption()) {
            value += Math.pow(bundle.size(), 1.0 + this.world.getAdditivity());
        }
        return new BigDecimal(value);
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, long seed) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(CatsXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new CatsXOR((Collection<CATSLicense>)this.world.getLicenses(), new JavaUtilRNGSupplier(seed), this)));
        }
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR<CATSLicense>((Collection<CATSLicense>)this.world.getLicenses(), new JavaUtilRNGSupplier(seed), this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR<CATSLicense>((Collection<CATSLicense>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR<CATSLicense>((Collection<CATSLicense>)this.world.getLicenses(), this)));
        }
        if (GenericLang.class.isAssignableFrom(clazz)) {
            throw new IncompatibleBiddingLanguageException("CATS is not suitable for XOR-Q, as it doesn't have generic items");
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public CATSWorld getWorld() {
        return this.world;
    }

    public ImmutableMap<Long, BigDecimal> getPrivateValues() {
        if (this.privateValueMap == null) {
            this.privateValueMap = ImmutableMap.copyOf(this.privateValues);
        }
        return this.privateValueMap;
    }

    @Override
    public void refreshReference(World world) {
        Preconditions.checkArgument((world.getId() == this.getWorldId() ? 1 : 0) != 0);
        if (!(world instanceof CATSWorld)) {
            throw new IllegalArgumentException("World is not of correct type");
        }
        this.world = (CATSWorld)world;
    }
}

