/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats;

import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.DefaultModel;
import org.spectrumauctions.sats.core.model.cats.CATSBidder;
import org.spectrumauctions.sats.core.model.cats.CATSBidderSetup;
import org.spectrumauctions.sats.core.model.cats.CATSWorld;
import org.spectrumauctions.sats.core.model.cats.CATSWorldSetup;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class CATSRegionModel
extends DefaultModel<CATSWorld, CATSBidder> {
    private final CATSWorldSetup.Builder worldSetupBuilder = new CATSWorldSetup.Builder();
    private final CATSBidderSetup.Builder bidderBuilder = new CATSBidderSetup.Builder();

    @Override
    public CATSWorld createWorld(RNGSupplier worldSeed) {
        return new CATSWorld(this.worldSetupBuilder.build(), worldSeed);
    }

    @Override
    public List<CATSBidder> createPopulation(CATSWorld world, RNGSupplier populationRNG) {
        ArrayList<CATSBidderSetup> setups = new ArrayList<CATSBidderSetup>();
        setups.add(this.bidderBuilder.build());
        return world.createPopulation(setups, populationRNG);
    }

    public void setNumberOfBidders(int numberOfBidders) {
        this.bidderBuilder.setNumberOfBidders(numberOfBidders);
    }

    public void setNumberOfGoods(int numberOfGoods) {
        this.worldSetupBuilder.setNumberOfGoodsInterval(new IntegerInterval(numberOfGoods));
    }
}

