/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class GSVMBidder
extends Bidder<GSVMLicense> {
    private static final long serialVersionUID = -7275733600491984673L;
    private final int bidderPosition;
    private final HashMap<Long, BigDecimal> values;
    private transient GSVMWorld world;

    GSVMBidder(GSVMBidderSetup setup, GSVMWorld world, int bidderPosition, long currentId, long population, RNGSupplier rngSupplier) {
        super(setup, population, currentId, world.getId());
        this.world = world;
        this.bidderPosition = bidderPosition % world.getSize();
        this.values = setup.drawValues(rngSupplier, this);
        this.store();
    }

    @Override
    public BigDecimal calculateValue(Bundle<GSVMLicense> bundle) {
        double value = 0.0;
        for (GSVMLicense license : bundle) {
            if (!this.values.containsKey(license.getId())) continue;
            value += this.values.get(license.getId()).doubleValue();
        }
        double factor = 0.0;
        if (!bundle.isEmpty()) {
            factor = 0.2 * (double)(bundle.size() - 1);
        }
        return BigDecimal.valueOf(value + value * factor);
    }

    public int getBidderPosition() {
        return this.bidderPosition;
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, long seed) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR<GSVMLicense>((Collection<GSVMLicense>)this.world.getLicenses(), new JavaUtilRNGSupplier(seed), this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR<GSVMLicense>((Collection<GSVMLicense>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR<GSVMLicense>((Collection<GSVMLicense>)this.world.getLicenses(), this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public GSVMWorld getWorld() {
        return this.world;
    }

    @Override
    public void refreshReference(World world) {
        Preconditions.checkArgument((world.getId() == this.getWorldId() ? 1 : 0) != 0);
        if (!(world instanceof GSVMWorld)) {
            throw new IllegalArgumentException("World is not of correct type");
        }
        this.world = (GSVMWorld)world;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GSVMBidder that = (GSVMBidder)o;
        return this.getBidderPosition() == that.getBidderPosition() && Objects.equals(this.values, that.values) && Objects.equals(this.getWorld(), that.getWorld());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBidderPosition(), this.values, this.getWorld());
    }

    public Map<Long, BigDecimal> getBaseValues() {
        return Collections.unmodifiableMap(this.values);
    }
}

