/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.lsvm;

import java.math.BigDecimal;
import java.util.HashMap;
import org.spectrumauctions.sats.core.model.BidderSetup;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidder;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.core.util.PreconditionUtils;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class LSVMBidderSetup
extends BidderSetup {
    private final DoubleInterval valueInterval;
    private final int proximitySize;
    private final int a;
    private final int b;

    private LSVMBidderSetup(Builder builder) {
        super(builder);
        this.valueInterval = builder.valueInterval;
        this.proximitySize = builder.proximitySize;
        this.a = builder.a;
        this.b = builder.b;
    }

    LSVMLicense drawFavorite(RNGSupplier rngSupplier, LSVMWorld world) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        int row = rng.nextInt(new IntegerInterval(0, world.getGrid().getNumberOfRows() - 1));
        int column = rng.nextInt(new IntegerInterval(0, world.getGrid().getNumberOfColumns() - 1));
        return world.getGrid().getLicense(row, column);
    }

    HashMap<Long, BigDecimal> drawValues(RNGSupplier rngSupplier, LSVMBidder lsvmBidder) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        HashMap<Long, BigDecimal> values = new HashMap<Long, BigDecimal>();
        for (LSVMLicense license : lsvmBidder.getProximity()) {
            values.put(license.getId(), rng.nextBigDecimal(this.valueInterval));
        }
        return values;
    }

    public DoubleInterval getValueInterval() {
        return this.valueInterval;
    }

    int getProximitySize() {
        return this.proximitySize;
    }

    int getLsvmA() {
        return this.a;
    }

    int getLsvmB() {
        return this.b;
    }

    public static class RegionalBidderBuilder
    extends Builder {
        public RegionalBidderBuilder() {
            super("Regional Bidder Setup", 5, new DoubleInterval(3.0, 20.0), 2, 160, 4);
        }

        public void setProximitySize(int proximitySize) {
            PreconditionUtils.checkNotNegative(proximitySize);
            ((Builder)this).proximitySize = proximitySize;
        }
    }

    public static class NationalBidderBuilder
    extends Builder {
        public NationalBidderBuilder() {
            super("National Bidder Setup", 1, new DoubleInterval(3.0, 9.0), -1, 320, 10);
        }
    }

    private static abstract class Builder
    extends BidderSetup.Builder {
        private DoubleInterval valueInterval;
        private int proximitySize;
        private int a;
        private int b;

        private Builder(String setupName, int numberOfBidders, DoubleInterval valueInterval, int proximitySize, int a, int b) {
            super(setupName, numberOfBidders);
            this.valueInterval = valueInterval;
            this.proximitySize = proximitySize;
            this.a = a;
            this.b = b;
        }

        public void setValueInterval(DoubleInterval newInterval) {
            this.valueInterval = newInterval;
        }

        public void setLsvmA(int a) {
            this.a = a;
        }

        public void setLsvmB(int b) {
            this.b = b;
        }

        @Override
        public LSVMBidderSetup build() {
            return new LSVMBidderSetup(this);
        }
    }
}

