/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.model.BidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public abstract class MRVMBidderSetup
extends BidderSetup {
    private final DoubleInterval alphaInterval;
    private final DoubleInterval betaInterval;
    private final DoubleInterval zLowInterval;
    private final DoubleInterval zHighInterval;
    private static final BigDecimal NONZERO_INCREMENT = BigDecimal.valueOf(0.01);

    protected MRVMBidderSetup(Builder builder) {
        super(builder);
        this.alphaInterval = builder.alphaInterval;
        this.betaInterval = builder.betaInterval;
        this.zLowInterval = builder.zLowInterval;
        this.zHighInterval = builder.zHighInterval;
    }

    public BigDecimal drawAlpha(UniformDistributionRNG rng) {
        return rng.nextBigDecimal(this.alphaInterval);
    }

    public BigDecimal drawBeta(MRVMRegionsMap.Region r, UniformDistributionRNG rng) {
        return rng.nextBigDecimal(this.betaInterval);
    }

    public HashMap<Integer, BigDecimal> drawZLow(Map<Integer, BigDecimal> betas, MRVMWorld world, UniformDistributionRNG rng) {
        HashMap<Integer, BigDecimal> result = new HashMap<Integer, BigDecimal>();
        for (Map.Entry<Integer, BigDecimal> beta : betas.entrySet()) {
            BigDecimal minTerm = beta.getValue().subtract(BigDecimal.valueOf(0.3));
            if (minTerm.compareTo(BigDecimal.ZERO) < 0) {
                minTerm = NONZERO_INCREMENT;
            }
            BigDecimal dividend = minTerm.multiply(world.getMaximumRegionalCapacity());
            MRVMRegionsMap.Region region = world.getRegionsMap().getRegion(beta.getKey());
            BigDecimal divisor = BigDecimal.valueOf(region.getPopulation()).multiply(beta.getValue());
            BigDecimal zvalue = dividend.divide(divisor, new MathContext(10, RoundingMode.UP));
            result.put(beta.getKey(), zvalue);
        }
        return result;
    }

    public HashMap<Integer, BigDecimal> drawZHigh(Map<Integer, BigDecimal> betas, MRVMWorld world, UniformDistributionRNG rng) {
        HashMap<Integer, BigDecimal> result = new HashMap<Integer, BigDecimal>();
        for (Map.Entry<Integer, BigDecimal> beta : betas.entrySet()) {
            BigDecimal maxTerm = beta.getValue().add(BigDecimal.valueOf(0.3));
            if (maxTerm.compareTo(BigDecimal.ONE) > 0) {
                maxTerm = BigDecimal.ONE;
            }
            BigDecimal dividend = maxTerm.multiply(world.getMaximumRegionalCapacity());
            MRVMRegionsMap.Region region = world.getRegionsMap().getRegion(beta.getKey());
            BigDecimal divisor = BigDecimal.valueOf(region.getPopulation()).multiply(beta.getValue());
            BigDecimal zvalue = dividend.divide(divisor, 4);
            result.put(beta.getKey(), zvalue);
        }
        return result;
    }

    public static abstract class Builder
    extends BidderSetup.Builder {
        private DoubleInterval alphaInterval;
        private DoubleInterval betaInterval;
        private DoubleInterval zLowInterval;
        private DoubleInterval zHighInterval;

        protected Builder(String setupName, int numberOfBidders, DoubleInterval alphaInterval, DoubleInterval betaInterval) {
            super(setupName, numberOfBidders);
            this.alphaInterval = alphaInterval;
            this.betaInterval = betaInterval;
        }

        public DoubleInterval getAlphaInterval() {
            return this.alphaInterval;
        }

        public void setAlphaInterval(DoubleInterval alphaInterval) {
            this.alphaInterval = alphaInterval;
        }

        public DoubleInterval getBetaInterval() {
            return this.betaInterval;
        }

        public void setBetaInterval(DoubleInterval betaInterval) {
            this.betaInterval = betaInterval;
        }

        public DoubleInterval getzLowInterval() {
            return this.zLowInterval;
        }

        public DoubleInterval getzHighInterval() {
            return this.zHighInterval;
        }

        public void setzLowInterval(DoubleInterval zLowInterval) {
            this.zLowInterval = zLowInterval;
        }

        public void setzHighInterval(DoubleInterval zHighInterval) {
            this.zHighInterval = zHighInterval;
        }

        @Override
        public abstract MRVMBidderSetup build();
    }
}

