/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;

public final class MRVMGenericDefinition
implements GenericDefinition<MRVMLicense> {
    private final MRVMBand band;
    private final MRVMRegionsMap.Region region;
    private transient ImmutableSet<MRVMLicense> licenses;

    public MRVMGenericDefinition(MRVMBand band, MRVMRegionsMap.Region region) {
        Preconditions.checkNotNull((Object)band);
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkArgument((boolean)band.getWorld().getRegionsMap().getRegions().contains(region));
        this.band = band;
        this.region = region;
    }

    public MRVMBand getBand() {
        return this.band;
    }

    public MRVMRegionsMap.Region getRegion() {
        return this.region;
    }

    public String toString() {
        return "[r=" + this.region.toString() + ",b=" + this.band.toString() + "]";
    }

    @Override
    public boolean isPartOf(MRVMLicense license) {
        return license != null && license.getBand().equals(this.band) && license.getRegion().equals(this.region);
    }

    public void checkQuantityIsValid(int quantity) {
        Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((quantity <= this.band.getNumberOfLots() ? 1 : 0) != 0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.band == null ? 0 : this.band.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMGenericDefinition other = (MRVMGenericDefinition)obj;
        if (this.band == null ? other.band != null : !this.band.equals(other.band)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }

    @Override
    public int numberOfLicenses() {
        return this.band.getNumberOfLots();
    }

    @Override
    public Set<MRVMLicense> allLicenses() {
        if (this.licenses == null) {
            ImmutableSet.Builder licBuilder = new ImmutableSet.Builder();
            for (MRVMLicense lic : this.band.getLicenses()) {
                if (!lic.getRegion().equals(this.region)) continue;
                licBuilder.add((Object)lic);
            }
            this.licenses = licBuilder.build();
        }
        return this.licenses;
    }

    @Override
    public JsonElement shortJson() {
        JsonObject json = new JsonObject();
        json.addProperty("band", this.band.getName());
        json.addProperty("region", (Number)this.region.getId());
        return json;
    }
}

