/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class RandomOrderXORQFactory
implements Serializable {
    private static final long serialVersionUID = -5801444096946669459L;
    private static BandComparator comparator = new BandComparator();

    public static XORQRandomOrderSimple<MRVMGenericDefinition, MRVMLicense> getXORQRandomOrderSimpleLang(MRVMBidder bidder, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        ArrayList<MRVMGenericDefinition> bands = new ArrayList<MRVMGenericDefinition>();
        for (MRVMBand band : bidder.getWorld().getBands()) {
            for (MRVMRegionsMap.Region region : bidder.getWorld().getRegionsMap().getRegions()) {
                bands.add(new MRVMGenericDefinition(band, region));
            }
        }
        return new SimpleRandomOrder(bands, bidder, rngSupplier);
    }

    public static XORQRandomOrderSimple<MRVMGenericDefinition, MRVMLicense> getXORQRandomOrderSimpleLang(MRVMBidder bidder) throws UnsupportedBiddingLanguageException {
        ArrayList<MRVMGenericDefinition> bands = new ArrayList<MRVMGenericDefinition>();
        for (MRVMBand band : bidder.getWorld().getBands()) {
            for (MRVMRegionsMap.Region region : bidder.getWorld().getRegionsMap().getRegions()) {
                bands.add(new MRVMGenericDefinition(band, region));
            }
        }
        return new SimpleRandomOrder(bands, bidder, new JavaUtilRNGSupplier());
    }

    private static class BandComparator
    implements Comparator<MRVMGenericDefinition>,
    Serializable {
        private static final long serialVersionUID = 8703079363133628481L;

        private BandComparator() {
        }

        @Override
        public int compare(MRVMGenericDefinition o1, MRVMGenericDefinition o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static final class SimpleRandomOrder
    extends XORQRandomOrderSimple<MRVMGenericDefinition, MRVMLicense> {
        private final MRVMBidder bidder;

        SimpleRandomOrder(Collection<MRVMGenericDefinition> allPossibleGenericDefinitions, MRVMBidder bidder, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefinitions, rngSupplier);
            this.bidder = bidder;
        }

        public Bidder<MRVMLicense> getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<MRVMGenericDefinition> getGenericBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<MRVMGenericDefinition> getDefComparator() {
            return comparator;
        }
    }
}

