/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

class RandomOrderXORQFactory
implements Serializable {
    private static final BandComparator comparator = new BandComparator();
    private static final long serialVersionUID = -337996389686369882L;

    RandomOrderXORQFactory() {
    }

    public static XORQRandomOrderSimple<SRVMBand, SRVMLicense> getXORQRandomOrderSimpleLang(SRVMBidder bidder, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        Set<SRVMBand> bands = bidder.getWorld().getBands();
        return new SimpleRandomOrder(bands, bidder, rngSupplier);
    }

    public static XORQRandomOrderSimple<SRVMBand, SRVMLicense> getXORQRandomOrderSimpleLang(SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
        Set<SRVMBand> bands = bidder.getWorld().getBands();
        return new SimpleRandomOrder(bands, bidder, new JavaUtilRNGSupplier());
    }

    private static class BandComparator
    implements Comparator<SRVMBand>,
    Serializable {
        private static final long serialVersionUID = -4955747961470283517L;

        private BandComparator() {
        }

        @Override
        public int compare(SRVMBand o1, SRVMBand o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static final class SimpleRandomOrder
    extends XORQRandomOrderSimple<SRVMBand, SRVMLicense> {
        private final SRVMBidder bidder;

        SimpleRandomOrder(Collection<SRVMBand> allPossibleGenericDefinitions, SRVMBidder bidder, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefinitions, rngSupplier);
            this.bidder = bidder;
        }

        public Bidder<SRVMLicense> getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<SRVMBand> getGenericBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<SRVMBand> getDefComparator() {
            return comparator;
        }
    }
}

