/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class SRVMWorldSetup {
    private final ImmutableMap<String, IntegerInterval> bandDefinitions;

    private SRVMWorldSetup(Builder builder) {
        this.bandDefinitions = ImmutableMap.copyOf(builder.bandDefinitions);
    }

    public Map<String, Integer> defineBands(RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        HashMap<String, Integer> bands = new HashMap<String, Integer>();
        for (Map.Entry bandDefinition : this.bandDefinitions.entrySet()) {
            bands.put((String)bandDefinition.getKey(), rng.nextInt((IntegerInterval)bandDefinition.getValue()));
        }
        return bands;
    }

    public static class Builder {
        public static final String BAND_NAME_A = "A";
        public static final String BAND_NAME_B = "B";
        public static final String BAND_NAME_C = "C";
        public Map<String, IntegerInterval> bandDefinitions = new HashMap<String, IntegerInterval>();

        public Builder() {
            this.bandDefinitions.put(BAND_NAME_A, new IntegerInterval(6));
            this.bandDefinitions.put(BAND_NAME_B, new IntegerInterval(14));
            this.bandDefinitions.put(BAND_NAME_C, new IntegerInterval(9));
        }

        public void putBand(String bandName, IntegerInterval numberOfLicenses) {
            Preconditions.checkArgument((boolean)numberOfLicenses.isStrictlyPositive());
            this.bandDefinitions.put(bandName, numberOfLicenses);
        }

        public Map<String, IntegerInterval> getBandDefinitions() {
            return Collections.unmodifiableMap(this.bandDefinitions);
        }

        public void removeBand(String bandName) {
            this.bandDefinitions.remove(bandName);
        }

        public SRVMWorldSetup build() {
            return new SRVMWorldSetup(this);
        }
    }
}

