/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowerset;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;

public class SizeOrderedGenericPowersetFactory {
    public static GenericPowerset<SRVMBand, SRVMLicense> getSizeOrderedGenericLang(boolean increasing, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
        ArrayList<SRVMBand> bands = new ArrayList<SRVMBand>(bidder.getWorld().getBands());
        if (increasing) {
            return new Increasing(bands, bidder);
        }
        return new Decreasing(bands, bidder);
    }

    private static final class Decreasing
    extends GenericPowersetDecreasing<SRVMBand, SRVMLicense> {
        private SRVMBidder bidder;

        protected Decreasing(List<SRVMBand> genericDefinitions, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(genericDefinitions);
            this.bidder = bidder;
        }

        @Override
        public Bidder<? extends Good> getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<SRVMBand> getGenericBidder() {
            return this.bidder;
        }
    }

    private static final class Increasing
    extends GenericPowersetIncreasing<SRVMBand, SRVMLicense> {
        private SRVMBidder bidder;

        protected Increasing(List<SRVMBand> genericDefinitions, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(genericDefinitions);
            this.bidder = bidder;
        }

        public SRVMBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<SRVMBand> getGenericBidder() {
            return this.bidder;
        }
    }
}

