/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.cca;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.generic.GenericBid;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.GenericWorld;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.mechanism.cca.CCAMechanism;
import org.spectrumauctions.sats.mechanism.cca.priceupdate.GenericPriceUpdater;
import org.spectrumauctions.sats.mechanism.cca.priceupdate.SimpleRelativeGenericPriceUpdate;
import org.spectrumauctions.sats.mechanism.cca.supplementaryround.GenericSupplementaryRound;
import org.spectrumauctions.sats.mechanism.cca.supplementaryround.ProfitMaximizingGenericSupplementaryRound;
import org.spectrumauctions.sats.mechanism.ccg.CCGMechanism;
import org.spectrumauctions.sats.mechanism.domain.MechanismResult;
import org.spectrumauctions.sats.mechanism.domain.mechanisms.AuctionMechanism;
import org.spectrumauctions.sats.mechanism.vcg.VCGMechanism;
import org.spectrumauctions.sats.opt.domain.Allocation;
import org.spectrumauctions.sats.opt.domain.GenericDemandQueryMIPBuilder;
import org.spectrumauctions.sats.opt.domain.GenericDemandQueryResult;
import org.spectrumauctions.sats.opt.xorq.XORQWinnerDetermination;

public class GenericCCAMechanism<G extends GenericDefinition<T>, T extends Good>
extends CCAMechanism<T> {
    private static final Logger logger = LogManager.getLogger(GenericCCAMechanism.class);
    private Collection<GenericBid<G, T>> bidsAfterClockPhase;
    private Collection<GenericBid<G, T>> bidsAfterSupplementaryRound;
    private Map<G, BigDecimal> finalPrices;
    private Map<G, Integer> finalDemand;
    private GenericDemandQueryMIPBuilder<G, T> genericDemandQueryMIPBuilder;
    private GenericPriceUpdater<G, T> priceUpdater = new SimpleRelativeGenericPriceUpdate();
    private List<GenericSupplementaryRound<G, T>> supplementaryRounds = new ArrayList<GenericSupplementaryRound<G, T>>();

    public GenericCCAMechanism(List<Bidder<T>> bidders, GenericDemandQueryMIPBuilder<G, T> genericDemandQueryMIPBuilder) {
        super(bidders);
        this.genericDemandQueryMIPBuilder = genericDemandQueryMIPBuilder;
    }

    @Override
    public MechanismResult<T> getMechanismResult() {
        if (this.result != null) {
            return this.result;
        }
        if (this.bidsAfterClockPhase == null) {
            logger.info("Starting clock phase for generic bids...");
            this.bidsAfterClockPhase = this.runClockPhase();
        }
        if (this.bidsAfterSupplementaryRound == null) {
            logger.info("Starting to collect bids for supplementary round...");
            this.bidsAfterSupplementaryRound = this.runSupplementaryRound();
        }
        logger.info("Starting to calculate payments with all collected bids...");
        this.result = this.calculatePayments();
        return this.result;
    }

    public Allocation<T> calculateClockPhaseAllocation() {
        if (this.bidsAfterClockPhase == null) {
            logger.info("Starting clock phase for generic bids...");
            this.bidsAfterClockPhase = this.runClockPhase();
        }
        HashSet<GenericBid<G, T>> bids = new HashSet<GenericBid<G, T>>(this.bidsAfterClockPhase);
        XORQWinnerDetermination<G, T> wdp = new XORQWinnerDetermination<G, T>(bids);
        return wdp.calculateAllocation();
    }

    public Allocation<T> calculateAllocationAfterSupplementaryRound() {
        if (this.bidsAfterClockPhase == null) {
            logger.info("Starting clock phase for generic bids...");
            this.bidsAfterClockPhase = this.runClockPhase();
        }
        if (this.bidsAfterSupplementaryRound == null) {
            logger.info("Starting to collect bids for supplementary round...");
            this.bidsAfterSupplementaryRound = this.runSupplementaryRound();
        }
        HashSet<GenericBid<G, T>> bids = new HashSet<GenericBid<G, T>>(this.bidsAfterSupplementaryRound);
        XORQWinnerDetermination<G, T> wdp = new XORQWinnerDetermination<G, T>(bids);
        return wdp.calculateAllocation();
    }

    public Collection<GenericBid<G, T>> getBidsAfterSupplementaryRound() {
        if (this.bidsAfterClockPhase == null) {
            this.runClockPhase();
        }
        if (this.bidsAfterSupplementaryRound == null) {
            this.runSupplementaryRound();
        }
        return this.bidsAfterSupplementaryRound;
    }

    private Collection<GenericBid<G, T>> runClockPhase() {
        HashMap bids = new HashMap();
        GenericWorld world = (GenericWorld)((Object)((Bidder)this.bidders.iterator().next()).getWorld());
        Map<Object, Object> prices = new HashMap();
        Set genericDefinitions = world.getAllGenericDefinitions();
        for (GenericDefinition def : genericDefinitions) {
            prices.put(def, this.startingPrice);
        }
        boolean done = false;
        while (!done) {
            HashMap<G, Integer> demand = new HashMap<G, Integer>();
            for (Bidder bidder : this.bidders) {
                List<GenericDemandQueryResult<G, T>> genericDemandQueryResults = this.genericDemandQueryMIPBuilder.getDemandQueryMipFor(bidder, prices, this.epsilon).getResultPool(this.clockPhaseNumberOfBundles);
                GenericValue<G, T> firstResult = genericDemandQueryResults.get(0).getResultingBundle();
                if (firstResult.getTotalQuantity() > 0) {
                    for (Map.Entry entry : genericDemandQueryResults.get(0).getResultingBundle().getQuantities().entrySet()) {
                        GenericDefinition def = (GenericDefinition)entry.getKey();
                        int quantity = (Integer)entry.getValue();
                        demand.put(def, demand.getOrDefault(def, 0) + quantity);
                    }
                }
                for (GenericDemandQueryResult<G, T> genericDemandQueryResult : genericDemandQueryResults) {
                    GenericValue<G, T> genericResult = genericDemandQueryResult.getResultingBundle();
                    if (genericResult.getTotalQuantity() <= 0) continue;
                    BigDecimal bid = BigDecimal.ZERO;
                    for (Map.Entry entry : genericResult.getQuantities().entrySet()) {
                        BigDecimal quantityTimesPrice = ((BigDecimal)prices.get(entry.getKey())).multiply(BigDecimal.valueOf(((Integer)entry.getValue()).intValue()));
                        bid = bid.add(quantityTimesPrice);
                    }
                    GenericBid currentBid = bids.getOrDefault(bidder, new GenericBid(bidder, new ArrayList()));
                    GenericValue existingValue = null;
                    for (GenericValue genericValue : currentBid.getValues()) {
                        if (!genericValue.getQuantities().equals(genericResult.getQuantities())) continue;
                        existingValue = genericValue;
                        break;
                    }
                    if (existingValue != null && existingValue.getValue().compareTo(bid) < 0) {
                        currentBid.removeValue(existingValue);
                    }
                    if (existingValue == null || existingValue.getValue().compareTo(bid) < 0) {
                        GenericValue.Builder bidBuilder = new GenericValue.Builder(bid);
                        genericResult.getQuantities().forEach(bidBuilder::putQuantity);
                        currentBid.addValue(bidBuilder.build());
                    }
                    bids.put(bidder, currentBid);
                }
            }
            Map<G, BigDecimal> updatedPrices = this.priceUpdater.updatePrices(prices, demand);
            if (prices.equals(updatedPrices) || this.totalRounds >= this.maxRounds) {
                done = true;
                this.finalDemand = demand;
                this.finalPrices = prices;
                continue;
            }
            prices = updatedPrices;
            ++this.totalRounds;
        }
        this.bidsAfterClockPhase = bids.values();
        return this.bidsAfterClockPhase;
    }

    private Collection<GenericBid<G, T>> runSupplementaryRound() {
        HashSet<GenericBid<G, T>> bids = new HashSet<GenericBid<G, T>>();
        if (this.supplementaryRounds.isEmpty()) {
            this.supplementaryRounds.add(new ProfitMaximizingGenericSupplementaryRound());
        }
        for (Bidder bidder : this.bidders) {
            ArrayList<GenericValue<G, T>> newValues = new ArrayList<GenericValue<G, T>>();
            for (GenericSupplementaryRound<G, T> supplementaryRound : this.supplementaryRounds) {
                newValues.addAll(supplementaryRound.getSupplementaryBids(this, bidder));
            }
            GenericBid bidderBid = this.bidsAfterClockPhase.stream().filter(bid -> bidder.equals(bid.getBidder())).findFirst().orElseThrow(NoSuchElementException::new);
            GenericBid newBid = bidderBid.copyOf();
            newValues.forEach(newBid::addValue);
            bids.add(newBid);
        }
        this.bidsAfterSupplementaryRound = bids;
        return bids;
    }

    private MechanismResult<T> calculatePayments() {
        AuctionMechanism mechanism;
        HashSet<GenericBid<G, T>> bids = new HashSet<GenericBid<G, T>>(this.bidsAfterSupplementaryRound);
        XORQWinnerDetermination<G, T> wdp = new XORQWinnerDetermination<G, T>(bids);
        switch (this.paymentRule) {
            case CCG: {
                mechanism = new CCGMechanism(wdp);
                break;
            }
            default: {
                mechanism = new VCGMechanism(wdp);
            }
        }
        this.result = mechanism.getMechanismResult();
        return this.result;
    }

    public int getSupplyMinusDemand() {
        GenericWorld world = (GenericWorld)((Object)((Bidder)this.bidders.iterator().next()).getWorld());
        Set genericDefinitions = world.getAllGenericDefinitions();
        int aggregateDemand = 0;
        int supply = 0;
        for (GenericDefinition def : genericDefinitions) {
            aggregateDemand += this.finalDemand.getOrDefault(def, 0).intValue();
            supply += def.numberOfLicenses();
        }
        return supply - aggregateDemand;
    }

    public void setPriceUpdater(GenericPriceUpdater<G, T> genericPriceUpdater) {
        Preconditions.checkArgument((this.bidsAfterClockPhase == null ? 1 : 0) != 0, (Object)"Already ran clock phase! Set the price updater before.");
        this.priceUpdater = genericPriceUpdater;
    }

    public void addSupplementaryRound(GenericSupplementaryRound<G, T> genericSupplementaryRound) {
        Preconditions.checkArgument((this.bidsAfterSupplementaryRound == null ? 1 : 0) != 0, (Object)"Already ran supplementary round!");
        this.supplementaryRounds.add(genericSupplementaryRound);
    }

    public Map<Bidder<T>, Integer> getBidCountAfterClockPhase() {
        HashMap map = new HashMap();
        this.bidsAfterClockPhase.forEach(bid -> map.put(bid.getBidder(), bid.getValues().size()));
        return map;
    }

    public Map<Bidder<T>, Integer> getBidCountAfterSupplementaryRound() {
        HashMap map = new HashMap();
        this.bidsAfterSupplementaryRound.forEach(bid -> map.put(bid.getBidder(), bid.getValues().size()));
        return map;
    }

    public GenericDemandQueryMIPBuilder<G, T> getDemandQueryBuilder() {
        return this.genericDemandQueryMIPBuilder;
    }

    public Map<G, BigDecimal> getFinalPrices() {
        return this.finalPrices;
    }

    public Map<G, BigDecimal> getLastPrices() {
        return this.priceUpdater.getLastPrices();
    }

    public GenericBid<G, T> getBidAfterClockPhase(Bidder<T> bidder) {
        for (GenericBid<G, T> bid : this.bidsAfterClockPhase) {
            if (!bid.getBidder().equals(bidder)) continue;
            return bid;
        }
        logger.warn("Couldn't find a bid for bidder {} after clock phase.", bidder);
        return null;
    }

    public GenericBid<G, T> getBidAfterSupplementaryRound(Bidder<T> bidder) {
        for (GenericBid<G, T> bid : this.bidsAfterSupplementaryRound) {
            if (!bid.getBidder().equals(bidder)) continue;
            return bid;
        }
        logger.warn("Couldn't find a bid for bidder {} after supplementary round.", bidder);
        return null;
    }
}

