/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.cca.priceupdate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.mechanism.cca.priceupdate.GenericPriceUpdater;

public class DemandDependentGenericPriceUpdate<G extends GenericDefinition<T>, T extends Good>
implements GenericPriceUpdater<G, T> {
    private static final BigDecimal DEFAULT_CONSTANT = BigDecimal.valueOf(1000000.0);
    private BigDecimal constant = DEFAULT_CONSTANT;
    private int round = 1;
    private Map<G, BigDecimal> lastPrices = new HashMap<G, BigDecimal>();

    @Override
    public Map<G, BigDecimal> updatePrices(Map<G, BigDecimal> oldPrices, Map<G, Integer> demand) {
        if (this.lastPrices.isEmpty()) {
            for (Map.Entry<G, BigDecimal> oldPriceEntry : oldPrices.entrySet()) {
                this.lastPrices.put(oldPriceEntry.getKey(), oldPriceEntry.getValue());
            }
        }
        HashMap<GenericDefinition, BigDecimal> newPrices = new HashMap<GenericDefinition, BigDecimal>();
        for (Map.Entry<G, BigDecimal> oldPriceEntry : oldPrices.entrySet()) {
            GenericDefinition def = (GenericDefinition)oldPriceEntry.getKey();
            BigDecimal diff = BigDecimal.valueOf(demand.getOrDefault(def, 0) - def.numberOfLicenses());
            BigDecimal factor = this.constant.divide(BigDecimal.valueOf(Math.sqrt(this.round)), RoundingMode.HALF_UP);
            BigDecimal newPrice = oldPriceEntry.getValue().add(factor.multiply(diff));
            newPrices.put(def, newPrice);
            if (newPrice.compareTo(oldPriceEntry.getValue()) <= 0) continue;
            this.lastPrices.put(def, oldPriceEntry.getValue());
        }
        ++this.round;
        return newPrices;
    }

    @Override
    public Map<G, BigDecimal> getLastPrices() {
        return this.lastPrices;
    }

    public void setConstant(BigDecimal priceUpdate) {
        this.constant = priceUpdate;
    }
}

