/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.cca.priceupdate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.mechanism.cca.priceupdate.NonGenericPriceUpdater;

public class SimpleRelativeNonGenericPriceUpdate<T extends Good>
implements NonGenericPriceUpdater<T> {
    private static final BigDecimal DEFAULT_PRICE_UPDATE = BigDecimal.valueOf(0.1);
    private static final BigDecimal DEFAULT_INITIAL_UPDATE = BigDecimal.valueOf(100000.0);
    private BigDecimal priceUpdate = DEFAULT_PRICE_UPDATE;
    private BigDecimal initialUpdate = DEFAULT_INITIAL_UPDATE;
    private Map<T, BigDecimal> lastPrices = new HashMap<T, BigDecimal>();

    @Override
    public Map<T, BigDecimal> updatePrices(Map<T, BigDecimal> oldPrices, Map<T, Integer> demand) {
        if (this.lastPrices.isEmpty()) {
            for (Map.Entry<T, BigDecimal> oldPriceEntry : oldPrices.entrySet()) {
                this.lastPrices.put(oldPriceEntry.getKey(), oldPriceEntry.getValue());
            }
        }
        HashMap<Good, BigDecimal> newPrices = new HashMap<Good, BigDecimal>();
        for (Map.Entry<T, BigDecimal> oldPriceEntry : oldPrices.entrySet()) {
            Good good = (Good)oldPriceEntry.getKey();
            if (demand.getOrDefault(good, 0) > 1) {
                this.lastPrices.put(good, oldPriceEntry.getValue());
                if (oldPriceEntry.getValue().equals(BigDecimal.ZERO)) {
                    newPrices.put(good, this.initialUpdate);
                    continue;
                }
                newPrices.put(good, oldPriceEntry.getValue().add(oldPriceEntry.getValue().multiply(this.priceUpdate)));
                continue;
            }
            newPrices.put(good, oldPriceEntry.getValue());
        }
        return newPrices;
    }

    @Override
    public Map<T, BigDecimal> getLastPrices() {
        return this.lastPrices;
    }

    public void setPriceUpdate(BigDecimal priceUpdate) {
        this.priceUpdate = priceUpdate;
    }

    public void setInitialUpdate(BigDecimal initialUpdate) {
        this.initialUpdate = initialUpdate;
    }

    public SimpleRelativeNonGenericPriceUpdate<T> withPriceUpdate(BigDecimal priceUpdate) {
        this.setPriceUpdate(priceUpdate);
        return this;
    }

    public SimpleRelativeNonGenericPriceUpdate<T> withInitialUpdate(BigDecimal initialUpdate) {
        this.setInitialUpdate(initialUpdate);
        return this;
    }
}

