/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.cca.supplementaryround;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericBid;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.mechanism.cca.GenericCCAMechanism;
import org.spectrumauctions.sats.mechanism.cca.supplementaryround.GenericSupplementaryRound;

public class LastBidsTrueValueGenericSupplementaryRound<G extends GenericDefinition<T>, T extends Good>
implements GenericSupplementaryRound<G, T> {
    private static final int DEFAULT_NUMBER_OF_SUPPLEMENTARY_BIDS = 500;
    private int numberOfSupplementaryBids = 500;

    @Override
    public List<GenericValue<G, T>> getSupplementaryBids(GenericCCAMechanism<G, T> cca, Bidder<T> bidder) {
        Preconditions.checkArgument((boolean)(bidder instanceof GenericValueBidder));
        GenericValueBidder genericBidder = (GenericValueBidder)((Object)bidder);
        GenericBid<G, T> bid = cca.getBidAfterClockPhase(bidder);
        ArrayList<GenericValue<G, T>> result = new ArrayList<GenericValue<G, T>>();
        int count = 0;
        for (int i = bid.getValues().size() - 1; i >= 0 && count++ < this.numberOfSupplementaryBids; --i) {
            GenericValue<G, T> value = bid.getValues().get(i);
            GenericValue.Builder builder = new GenericValue.Builder(genericBidder);
            for (Map.Entry entry : value.getQuantities().entrySet()) {
                builder.putQuantity((GenericDefinition)entry.getKey(), (Integer)entry.getValue());
            }
            result.add(builder.build());
        }
        return result;
    }

    public void setNumberOfSupplementaryBids(int numberOfSupplementaryBids) {
        this.numberOfSupplementaryBids = numberOfSupplementaryBids;
    }

    public LastBidsTrueValueGenericSupplementaryRound<G, T> withNumberOfSupplementaryBids(int numberOfSupplementaryBids) {
        this.numberOfSupplementaryBids = numberOfSupplementaryBids;
        return this;
    }
}

