/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.vcg;

import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.mechanism.domain.BidderPayment;
import org.spectrumauctions.sats.mechanism.domain.MechanismResult;
import org.spectrumauctions.sats.mechanism.domain.Payment;
import org.spectrumauctions.sats.mechanism.domain.mechanisms.AuctionMechanism;
import org.spectrumauctions.sats.opt.domain.Allocation;
import org.spectrumauctions.sats.opt.domain.WinnerDeterminator;

public class VCGMechanism<T extends Good>
implements AuctionMechanism<T> {
    private WinnerDeterminator<T> baseWD;
    private MechanismResult<T> result;

    public VCGMechanism(WinnerDeterminator<T> wdp) {
        this.baseWD = wdp;
    }

    @Override
    public MechanismResult<T> getMechanismResult() {
        if (this.result == null) {
            this.result = this.calculateVCGPayments();
        }
        return this.result;
    }

    @Override
    public Payment<T> getPayment() {
        return this.getMechanismResult().getPayment();
    }

    @Override
    public WinnerDeterminator<T> getWdWithoutBidder(Bidder<T> bidder) {
        return this.baseWD.getWdWithoutBidder(bidder);
    }

    @Override
    public Allocation<T> calculateAllocation() {
        return this.getMechanismResult().getAllocation();
    }

    @Override
    public WinnerDeterminator<T> copyOf() {
        return this.baseWD.copyOf();
    }

    @Override
    public void adjustPayoffs(Map<Bidder<T>, Double> payoffs) {
        this.baseWD.adjustPayoffs(payoffs);
    }

    private MechanismResult<T> calculateVCGPayments() {
        Allocation<T> baseAllocation = this.baseWD.calculateAllocation();
        HashMap payments = new HashMap();
        for (Bidder<T> bidder : baseAllocation.getWinners()) {
            double baseAllocationTotalValue = baseAllocation.getTotalValue().doubleValue();
            double baseAllocationBidderValue = baseAllocation.getTradeValue(bidder).doubleValue();
            double valueWithoutBidder = baseAllocationTotalValue - baseAllocationBidderValue;
            WinnerDeterminator<T> wdWithoutBidder = this.baseWD.getWdWithoutBidder(bidder);
            Allocation<T> allocationWithoutBidder = wdWithoutBidder.calculateAllocation();
            double valueWDWithoutBidder = allocationWithoutBidder.getTotalValue().doubleValue();
            double paymentAmount = valueWDWithoutBidder - valueWithoutBidder;
            payments.put(bidder, new BidderPayment(paymentAmount));
        }
        Payment payment = new Payment(payments);
        return new MechanismResult(payment, baseAllocation);
    }
}

