/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.lsvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidder;
import org.spectrumauctions.sats.core.model.lsvm.LSVMGrid;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.opt.domain.ItemAllocation;
import org.spectrumauctions.sats.opt.domain.WinnerDeterminator;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.lsvm.LSVMGridGraph;

public class LSVMStandardMIP
extends ModelMIP
implements WinnerDeterminator<LSVMLicense> {
    private Map<LSVMBidder, Map<LSVMLicense, Double>> valueMap;
    private List<LSVMBidder> population;
    private LSVMWorld world;
    private Map<LSVMBidder, Map<LSVMLicense, Map<Integer, Variable>>> aVariables;
    private Map<LSVMBidder, Map<Edge, Map<Integer, Variable>>> eVariables;
    private Map<Edge, Set<Integer>> validPathLengths = new HashMap<Edge, Set<Integer>>();

    public LSVMStandardMIP(List<LSVMBidder> population) {
        this(population.iterator().next().getWorld(), population);
    }

    public LSVMStandardMIP(LSVMWorld world, List<LSVMBidder> population) {
        this.world = world;
        this.population = population;
        this.getMip().setObjectiveMax(true);
        this.getMip().setSolveParam(SolveParam.TIME_LIMIT, (Object)3600.0);
        this.initBaseValues();
        this.initA();
        this.initEdge();
        this.initE();
        this.buildObjectiveTerm();
        this.buildSupplyEvalConstraints();
        this.buildEdgeSupplyConstraints();
        this.buildNeighbourConstraints();
        this.buildEdgeConstraints();
        this.buildTauConstraints();
    }

    @Override
    public WinnerDeterminator<LSVMLicense> getWdWithoutBidder(Bidder bidder) {
        Preconditions.checkArgument((boolean)this.population.contains(bidder));
        return new LSVMStandardMIP(this.population.stream().filter(b -> !b.equals(bidder)).collect(Collectors.toList()));
    }

    @Override
    public ItemAllocation<LSVMLicense> calculateAllocation() {
        SolverClient solver = new SolverClient();
        IMIPResult result = solver.solve((IMIP)this.getMip());
        HashMap allocation = new HashMap();
        for (LSVMBidder bidder : this.population) {
            Bundle<LSVMLicense> bundle = new Bundle<LSVMLicense>();
            for (LSVMLicense license : this.world.getLicenses()) {
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    if (!(result.getValue(this.aVariables.get(bidder).get(license).get(tau)) > 0.0)) continue;
                    bundle.add(license);
                }
            }
            allocation.put(bidder, bundle);
        }
        ItemAllocation.ItemAllocationBuilder builder = new ItemAllocation.ItemAllocationBuilder().withWorld(this.world).withTotalValue(BigDecimal.valueOf(result.getObjectiveValue())).withAllocation(allocation);
        return builder.build();
    }

    public Map<Integer, Variable> getXVariables(LSVMBidder bidder, LSVMLicense license) {
        for (LSVMBidder b : this.population) {
            if (!b.equals(bidder)) continue;
            for (LSVMLicense l : this.world.getLicenses()) {
                if (!l.equals(license)) continue;
                return this.aVariables.get(b).get(l);
            }
        }
        return new HashMap<Integer, Variable>();
    }

    @Override
    public WinnerDeterminator<LSVMLicense> copyOf() {
        return new LSVMStandardMIP(this.population);
    }

    @Override
    public void adjustPayoffs(Map<Bidder<LSVMLicense>, Double> payoffs) {
        throw new UnsupportedOperationException("The LSVM MIP does not support CCG yet.");
    }

    private void buildObjectiveTerm() {
        for (LSVMBidder bidder : this.population) {
            for (LSVMLicense license : this.world.getLicenses()) {
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    double value = this.calculateComplementarityMarkup(tau + 1, bidder) * this.valueMap.get(bidder).get(license);
                    this.getMip().addObjectiveTerm(value, this.aVariables.get(bidder).get(license).get(tau));
                }
            }
        }
    }

    private void buildSupplyEvalConstraints() {
        for (LSVMLicense license : this.world.getLicenses()) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
            for (LSVMBidder bidder : this.population) {
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    constraint.addTerm(1.0, this.aVariables.get(bidder).get(license).get(tau));
                }
            }
            this.getMip().add(constraint);
        }
    }

    private void buildEdgeSupplyConstraints() {
        for (Map.Entry<Edge, Set<Integer>> entry : this.validPathLengths.entrySet()) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
            for (LSVMBidder bidder : this.population) {
                for (int c = 0; c < this.world.getLicenses().size(); ++c) {
                    if (!entry.getValue().contains(c + 1)) continue;
                    constraint.addTerm(1.0, this.eVariables.get(bidder).get(entry.getKey()).get(c));
                }
            }
            this.getMip().add(constraint);
        }
    }

    private void buildNeighbourConstraints() {
        for (LSVMBidder bidder : this.population) {
            for (Map.Entry<Edge, Set<Integer>> entry : this.validPathLengths.entrySet()) {
                Edge edge = entry.getKey();
                for (int c = 1; c < this.world.getLicenses().size(); ++c) {
                    if (!entry.getValue().contains(c + 1)) continue;
                    Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                    constraint.addTerm(-1.0, this.eVariables.get(bidder).get(edge).get(c));
                    for (LSVMLicense x : this.n(this.gMin(edge))) {
                        Edge e;
                        LSVMLicense y;
                        if (x.equals(y = this.gMax(edge)) || !this.validPathLengths.get(e = this.fInv(x, y)).contains(c)) continue;
                        constraint.addTerm(1.0, this.eVariables.get(bidder).get(e).get(c - 1));
                    }
                    this.getMip().add(constraint);
                }
            }
        }
    }

    private void buildEdgeConstraints() {
        for (LSVMBidder bidder : this.population) {
            for (Map.Entry<Edge, Set<Integer>> entry : this.validPathLengths.entrySet()) {
                Edge edge = entry.getKey();
                Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                for (int c = 0; c < this.world.getLicenses().size(); ++c) {
                    if (!entry.getValue().contains(c + 1)) continue;
                    constraint.addTerm(-2.0, this.eVariables.get(bidder).get(edge).get(c));
                }
                for (LSVMLicense license : this.f(edge)) {
                    for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                        constraint.addTerm(1.0, this.aVariables.get(bidder).get(license).get(tau));
                    }
                }
                this.getMip().add(constraint);
            }
        }
    }

    private void buildTauConstraints() {
        for (LSVMBidder bidder : this.population) {
            for (LSVMLicense license : this.world.getLicenses()) {
                Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    constraint.addTerm((double)(tau + 1), this.aVariables.get(bidder).get(license).get(tau));
                }
                for (LSVMLicense other : this.world.getLicenses()) {
                    if (other.equals(license)) continue;
                    for (int c = 0; c < this.world.getLicenses().size(); ++c) {
                        Edge edge = this.fInv(other, license);
                        if (!this.validPathLengths.get(edge).contains(c + 1)) continue;
                        constraint.addTerm(-1.0, this.eVariables.get(bidder).get(edge).get(c));
                    }
                }
                this.getMip().add(constraint);
            }
        }
    }

    private void initBaseValues() {
        this.valueMap = new HashMap<LSVMBidder, Map<LSVMLicense, Double>>();
        for (LSVMBidder bidder : this.population) {
            this.valueMap.put(bidder, new HashMap());
            for (LSVMLicense license : this.world.getLicenses()) {
                this.valueMap.get(bidder).put(license, bidder.getBaseValues().getOrDefault(license.getId(), BigDecimal.ZERO).doubleValue());
            }
        }
    }

    private void initA() {
        this.aVariables = new HashMap<LSVMBidder, Map<LSVMLicense, Map<Integer, Variable>>>();
        for (LSVMBidder bidder : this.population) {
            this.aVariables.put(bidder, new HashMap());
            for (LSVMLicense license : this.world.getLicenses()) {
                this.aVariables.get(bidder).put(license, new HashMap());
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    Variable var = new Variable(String.format("A_i[%d]j[%d]tau[%d]", (int)bidder.getId(), (int)license.getId(), tau), VarType.BOOLEAN, 0.0, 1.0);
                    this.getMip().add(var);
                    this.aVariables.get(bidder).get(license).put(tau, var);
                }
            }
        }
    }

    private void initEdge() {
        for (LSVMLicense l1 : this.world.getLicenses()) {
            for (LSVMLicense l2 : this.world.getLicenses()) {
                Edge edge = new Edge(l1, l2);
                if (this.validPathLengths.containsKey(edge)) continue;
                this.buildValidPathLength(edge);
            }
        }
    }

    private void buildValidPathLength(Edge edge) {
        LSVMGridGraph grid = new LSVMGridGraph(this.world.getGrid());
        Set<Set<Vertex>> allPaths = grid.findAllPaths(grid.getVertex(edge.l1), grid.getVertex(edge.l2));
        List sizeOrderedPaths = allPaths.stream().sorted(Comparator.comparingInt(Set::size)).collect(Collectors.toList());
        ArrayList<Set> solution = new ArrayList<Set>();
        for (Set current : sizeOrderedPaths) {
            if (!solution.stream().noneMatch(current::containsAll)) continue;
            solution.add(current);
        }
        Set valid = solution.stream().map(path -> path.size() - 1).collect(Collectors.toSet());
        this.validPathLengths.put(edge, valid);
    }

    private void initE() {
        this.eVariables = new HashMap<LSVMBidder, Map<Edge, Map<Integer, Variable>>>();
        for (LSVMBidder bidder : this.population) {
            this.eVariables.put(bidder, new HashMap());
            for (Map.Entry<Edge, Set<Integer>> entry : this.validPathLengths.entrySet()) {
                this.eVariables.get(bidder).put(entry.getKey(), new HashMap());
                for (int c = 0; c < this.world.getLicenses().size(); ++c) {
                    if (!entry.getValue().contains(c + 1)) continue;
                    Variable var = new Variable(String.format("E_i[%d]e[%s]c[%d]", (int)bidder.getId(), entry.getKey(), c), VarType.BOOLEAN, 0.0, 1.0);
                    this.getMip().add(var);
                    this.eVariables.get(bidder).get(entry.getKey()).put(c, var);
                }
            }
        }
    }

    private double calculateComplementarityMarkup(int tau, LSVMBidder bidder) {
        if (tau < 1) {
            throw new IllegalArgumentException("Error: tau has to be >=1");
        }
        return bidder.calculateFactor(tau);
    }

    private LSVMLicense gMin(Edge e) {
        int neighbourCountL2;
        int neighbourCountL1 = this.n(e.l1).size();
        if (neighbourCountL1 <= (neighbourCountL2 = this.n(e.l2).size())) {
            return e.l1;
        }
        return e.l2;
    }

    private LSVMLicense gMax(Edge e) {
        Set<LSVMLicense> immutableSet = this.f(e);
        LSVMLicense minLicense = this.gMin(e);
        Set mutableSet = immutableSet.stream().filter(l -> !l.equals(minLicense)).collect(Collectors.toSet());
        assert (mutableSet.size() == 1);
        return (LSVMLicense)mutableSet.iterator().next();
    }

    private Set<LSVMLicense> n(LSVMLicense license) {
        LSVMGrid grid = this.world.getGrid();
        return this.world.getLicenses().stream().filter(x -> grid.isNeighbor((LSVMLicense)x, license)).collect(Collectors.toSet());
    }

    private Set<LSVMLicense> f(Edge e) {
        return ImmutableSet.of((Object)e.l1, (Object)e.l2);
    }

    private Edge fInv(LSVMLicense l1, LSVMLicense l2) {
        for (Edge edge : this.validPathLengths.keySet()) {
            if ((edge.l1 != l1 || edge.l2 != l2) && (edge.l1 != l2 || edge.l2 != l1)) continue;
            return edge;
        }
        throw new IllegalStateException("Error: fInv edge not found");
    }

    public class Edge {
        LSVMLicense l1;
        LSVMLicense l2;

        public Edge(LSVMLicense l1, LSVMLicense l2) {
            if (l1.getId() > l2.getId()) {
                this.l1 = l1;
                this.l2 = l2;
            } else {
                this.l2 = l1;
                this.l1 = l2;
            }
        }

        public String toString() {
            return "Edge(" + (int)this.l1.getId() + "," + (int)this.l2.getId() + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return Objects.equals(this.l1, edge.l1) && Objects.equals(this.l2, edge.l2);
        }

        public int hashCode() {
            return Objects.hash(this.l1, this.l2);
        }
    }
}

