/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.generic.Band;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.opt.domain.PartialMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMBidderPartialMIP;

public class MRVMWorldPartialMip
extends PartialMIP {
    private static final Logger logger = LogManager.getLogger(MRVMWorldPartialMip.class);
    public static final String xVariablePrefix = "X_";
    public static final String valueVariablePrefix = "v_";
    private final Map<MRVMBidder, Map<MRVMRegionsMap.Region, Map<Band, Variable>>> xVariables;
    private final Map<MRVMBidder, Variable> valueVariables;
    private final double biggestPossibleValue;
    private final Set<MRVMBidder> bidders;
    private final MRVMWorld world;

    MRVMWorldPartialMip(Collection<MRVMBidder> bidders2, double biggestPossibleValue) {
        Preconditions.checkNotNull(bidders2);
        Preconditions.checkArgument((bidders2.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((biggestPossibleValue <= 5.3687091E8 ? 1 : 0) != 0);
        this.biggestPossibleValue = biggestPossibleValue;
        this.bidders = Collections.unmodifiableSet(new HashSet<MRVMBidder>(bidders2));
        this.world = bidders2.iterator().next().getWorld();
        Preconditions.checkNotNull((Object)this.world);
        this.xVariables = this.initXVariables();
        this.valueVariables = this.initValueVariables();
    }

    private Set<Constraint> createNumberOfLicensesConstraints() {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (MRVMBand band : this.world.getBands()) {
            int lots = band.getNumberOfLots();
            for (MRVMRegionsMap.Region region : this.world.getRegionsMap().getRegions()) {
                Constraint numberOfLotsConstraint = new Constraint(CompareType.LEQ, (double)lots);
                for (MRVMBidder bidder : this.bidders) {
                    Variable xVar = this.getXVariable(bidder, region, band);
                    numberOfLotsConstraint.addTerm(1.0, xVar);
                }
                result.add(numberOfLotsConstraint);
            }
        }
        return result;
    }

    private Map<MRVMBidder, Variable> initValueVariables() {
        HashMap<MRVMBidder, Variable> result = new HashMap<MRVMBidder, Variable>();
        for (MRVMBidder bidder : this.bidders) {
            String varName = valueVariablePrefix + "_" + bidder.getId();
            Variable var = new Variable(varName, VarType.DOUBLE, 0.0, 5.3687091E8);
            result.put(bidder, var);
        }
        return Collections.unmodifiableMap(result);
    }

    private Map<MRVMBidder, Map<MRVMRegionsMap.Region, Map<Band, Variable>>> initXVariables() {
        HashMap result = new HashMap();
        for (MRVMBidder bidder : this.bidders) {
            HashMap biddersMap = new HashMap();
            for (MRVMRegionsMap.Region region : this.world.getRegionsMap().getRegions()) {
                HashMap<MRVMBand, Variable> bandMap = new HashMap<MRVMBand, Variable>();
                for (MRVMBand band : this.world.getBands()) {
                    String varName = xVariablePrefix.concat(MRVMBidderPartialMIP.createIndex(bidder, region, band));
                    Variable var = new Variable(varName, VarType.INT, 0.0, (double)band.getNumberOfLots());
                    bandMap.put(band, var);
                }
                biddersMap.put(region, Collections.unmodifiableMap(bandMap));
            }
            result.put(bidder, Collections.unmodifiableMap(biddersMap));
        }
        return Collections.unmodifiableMap(result);
    }

    private void appendObjectiveToMip(MIP mip) {
        mip.setObjectiveMax(true);
        if (!mip.getObjectiveTerms().isEmpty()) {
            logger.warn("There are already existing objective values, when there's still supposed to be none");
        }
        for (Variable var : this.valueVariables.values()) {
            mip.addObjectiveTerm(1.0, var);
        }
    }

    @Override
    public void appendToMip(MIP mip) {
        super.appendToMip(mip);
        this.appendObjectiveToMip(mip);
    }

    @Override
    public void appendConstraintsToMip(MIP mip) {
        super.appendConstraintsToMip(mip);
        for (Constraint c : this.createNumberOfLicensesConstraints()) {
            mip.add(c);
        }
    }

    @Override
    public void appendVariablesToMip(MIP mip) {
        super.appendVariablesToMip(mip);
        for (Variable variable : this.valueVariables.values()) {
            mip.add(variable);
        }
        for (Map map : this.xVariables.values()) {
            for (Map innerMap : map.values()) {
                for (Variable var : innerMap.values()) {
                    mip.add(var);
                }
            }
        }
    }

    public Variable getXVariable(MRVMBidder bidder, MRVMRegionsMap.Region region, MRVMBand band) {
        Variable var = this.xVariables.get(bidder).get(region).get(band);
        if (var == null) {
            throw new NullPointerException();
        }
        return var;
    }

    public Set<Variable> getXVariables(MRVMBidder bidder) {
        HashSet<Variable> variables = new HashSet<Variable>();
        for (Map.Entry<MRVMRegionsMap.Region, Map<Band, Variable>> entry : this.xVariables.get(bidder).entrySet()) {
            variables.addAll(entry.getValue().values());
        }
        return variables;
    }

    public Variable getValueVariable(MRVMBidder bidder) {
        Variable var = this.valueVariables.get(bidder);
        if (var == null) {
            throw new NullPointerException();
        }
        return var;
    }

    public double getBiggestPossibleValue() {
        return this.biggestPossibleValue;
    }
}

