/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;

public class Scalor {
    private static final Logger logger = LogManager.getLogger(Scalor.class);
    public static BigDecimal highestValidVal = BigDecimal.valueOf(535870910L);

    public static double scalingFactor(Collection<MRVMBidder> bidders) {
        double proposedSVScaling = Scalor.calculateSVScalingFactor(bidders);
        double proposedOmegaScaling = Scalor.calculateOmegaScalingFactor(bidders);
        if (proposedOmegaScaling > proposedSVScaling) {
            return proposedOmegaScaling;
        }
        return proposedSVScaling;
    }

    private static double calculateSVScalingFactor(Collection<MRVMBidder> bidders) {
        BigDecimal MIP_MAX_VALUE;
        MRVMBidder biggestAlphaBidder = bidders.stream().max(Comparator.comparing(b -> b.getAlpha())).get();
        MRVMRegionsMap.Region biggestRegion = bidders.stream().findAny().get().getWorld().getRegionsMap().getRegions().stream().max(Comparator.comparing(r -> r.getPopulation())).get();
        BigDecimal biggestAlpha = biggestAlphaBidder.getAlpha();
        BigDecimal biggestPopulation = BigDecimal.valueOf(biggestRegion.getPopulation());
        BigDecimal biggestC = bidders.stream().findAny().get().getWorld().getMaximumRegionalCapacity();
        BigDecimal securityBuffer = BigDecimal.valueOf(100000L);
        BigDecimal biggestSv = biggestAlpha.multiply(biggestPopulation).multiply(biggestC).add(securityBuffer);
        BigDecimal proposedScalingFactor = biggestSv.divide(MIP_MAX_VALUE = BigDecimal.valueOf(0x1FFFFFFEL), RoundingMode.HALF_DOWN);
        if (proposedScalingFactor.compareTo(BigDecimal.ONE) <= 0) {
            return 1.0;
        }
        return Math.round(proposedScalingFactor.doubleValue()) + 1L;
    }

    private static double calculateOmegaScalingFactor(Collection<MRVMBidder> bidders) {
        BigDecimal maxVal = Scalor.biggestUnscaledPossibleValue(bidders);
        if (maxVal.compareTo(highestValidVal) < 0) {
            return 1.0;
        }
        logger.debug("Scaling MIP-CALC");
        BigDecimal proposedScalingFactor = maxVal.divide(highestValidVal, RoundingMode.HALF_DOWN);
        return Math.round(proposedScalingFactor.doubleValue()) + 1L;
    }

    public static BigDecimal biggestUnscaledPossibleValue(Collection<MRVMBidder> bidders) {
        BigDecimal biggestValue = BigDecimal.ZERO;
        for (MRVMBidder bidder : bidders) {
            BigDecimal val = bidder.calculateValue(new Bundle<MRVMLicense>((Collection<MRVMLicense>)bidder.getWorld().getLicenses()));
            if (val.compareTo(biggestValue) <= 0) continue;
            biggestValue = val;
        }
        return biggestValue;
    }
}

