/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.srvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.Band;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.util.math.ContinuousPiecewiseLinearFunction;
import org.spectrumauctions.sats.opt.domain.PartialMIP;
import org.spectrumauctions.sats.opt.domain.PiecewiseLinearPartialMIP;
import org.spectrumauctions.sats.opt.model.srvm.SRVMWorldPartialMip;

public class SRVMBidderPartialMIP
extends PartialMIP {
    private static final String zVariablePrefix = "Z";
    private static final String wVariablePrefix = "W";
    private static final String valueVariablePrefix = "v";
    private Map<Band, Variable> zVariables;
    private Variable wVariable;
    private Map<Band, Variable> valueVariables;
    private Map<Band, Variable> alphaVariables;
    private Map<Band, Variable> betaVariables;
    private Map<Band, Variable> gammaVariables;
    protected final SRVMWorldPartialMip worldPartialMip;
    private final SRVMBidder bidder;

    public SRVMBidderPartialMIP(SRVMBidder bidder, SRVMWorldPartialMip worldMip) {
        this.bidder = bidder;
        this.worldPartialMip = worldMip;
        this.initVariables();
    }

    private void initVariables() {
        this.zVariables = this.createZVariables();
        this.wVariable = new Variable("W_" + this.bidder.getId(), VarType.BOOLEAN, 0.0, 1.0);
        this.valueVariables = this.createValueVariables();
        this.alphaVariables = this.createHelperVariables("alpha");
        this.betaVariables = this.createHelperVariables("beta");
        this.gammaVariables = this.createHelperVariables("gamma");
    }

    private Map<Band, Variable> createZVariables() {
        HashMap<Band, Variable> result = new HashMap<Band, Variable>();
        for (Band band : this.bidder.getWorld().getBands()) {
            String varName = zVariablePrefix.concat(SRVMBidderPartialMIP.createIndex(this.bidder, band));
            Variable var = new Variable(varName, VarType.BOOLEAN, 0.0, 1.0);
            result.put(band, var);
        }
        return result;
    }

    private Map<Band, Variable> createHelperVariables(String prefix) {
        HashMap<Band, Variable> result = new HashMap<Band, Variable>();
        for (Band band : this.bidder.getWorld().getBands()) {
            String varName = prefix.concat(SRVMBidderPartialMIP.createIndex(this.bidder, band));
            Variable var = new Variable(varName, VarType.DOUBLE, 0.0, 5.3687091E8);
            result.put(band, var);
        }
        return result;
    }

    private Map<Band, Variable> createValueVariables() {
        HashMap<Band, Variable> result = new HashMap<Band, Variable>();
        for (Band band : this.bidder.getWorld().getBands()) {
            String varName = valueVariablePrefix.concat(SRVMBidderPartialMIP.createIndex(this.bidder, band));
            Variable var = new Variable(varName, VarType.DOUBLE, 0.0, 5.3687091E8);
            result.put(band, var);
        }
        return result;
    }

    Variable getzVariable(Band band) {
        Variable var = this.zVariables.get(band);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    Variable getwVariable() {
        return this.wVariable;
    }

    Variable getValueVariable(Band band) {
        Variable var = this.valueVariables.get(band);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    Variable getAlphaVariable(Band band) {
        Variable var = this.alphaVariables.get(band);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    Variable getBetaVariable(Band band) {
        Variable var = this.betaVariables.get(band);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    Variable getGammaVariable(Band band) {
        Variable var = this.gammaVariables.get(band);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    static String createIndex(Bidder<?> bidder, Band band) {
        StringBuilder builder = new StringBuilder("_b");
        builder.append(bidder.getId());
        builder.append(",band_");
        builder.append(band.getName());
        return builder.toString();
    }

    Set<Constraint> generatezConstraints() {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (Band band : this.bidder.getWorld().getBands()) {
            Variable x = this.worldPartialMip.getXVariable(this.bidder, band);
            Constraint zgeq = new Constraint(CompareType.LEQ, 0.0);
            zgeq.addTerm(-1.0, this.getzVariable(band));
            zgeq.addTerm(1.0 / (double)band.getNumberOfLicenses(), x);
            result.add(zgeq);
            Constraint zleq = new Constraint(CompareType.GEQ, 0.0);
            zleq.addTerm(-1.0, this.getzVariable(band));
            zleq.addTerm(1.0, x);
            result.add(zleq);
        }
        return result;
    }

    Set<Constraint> generatewConstraints() {
        int sumNb = this.bidder.getWorld().getBands().size();
        HashSet<Constraint> result = new HashSet<Constraint>();
        Constraint wgeq = new Constraint(CompareType.LEQ, 1.0 / (double)sumNb);
        wgeq.addTerm(-1.0, this.getwVariable());
        Constraint wleq = new Constraint(CompareType.GEQ, 0.0);
        wleq.addTerm(-1.0, this.getwVariable());
        for (Band band : this.bidder.getWorld().getBands()) {
            wgeq.addTerm(1.0 / (double)band.getNumberOfLicenses(), this.getzVariable(band));
            wleq.addTerm(0.5, this.getzVariable(band));
        }
        result.add(wgeq);
        result.add(wleq);
        return result;
    }

    Set<Constraint> generateInterBandSynergyConstraints() {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (Band band : this.bidder.getWorld().getBands()) {
            Variable vm = this.worldPartialMip.getVmVariable(this.bidder, band);
            Constraint c1 = new Constraint(CompareType.GEQ, -5.3687091E8);
            c1.addTerm(-1.0, vm);
            c1.addTerm(1.0, this.getValueVariable(band));
            c1.addTerm(-5.3687091E8, this.getwVariable());
            result.add(c1);
            Constraint c2 = new Constraint(CompareType.LEQ, 5.3687091E8);
            c2.addTerm(-1.0, vm);
            c2.addTerm(1.0, this.getValueVariable(band));
            c2.addTerm(5.3687091E8, this.getwVariable());
            result.add(c2);
            Constraint c3 = new Constraint(CompareType.GEQ, 0.0);
            c3.addTerm(-1.0, vm);
            c3.addTerm(5.3687091E8, this.getwVariable());
            result.add(c3);
            Constraint c4 = new Constraint(CompareType.EQ, 0.0);
            c4.addTerm(-1.0, this.worldPartialMip.getVoVariable(this.bidder, band));
            c4.addTerm(1.0, this.getValueVariable(band));
            c4.addTerm(-1.0, vm);
            result.add(c4);
        }
        return result;
    }

    Set<Constraint> generateValueConstraints() {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (Band band : this.bidder.getWorld().getBands()) {
            double baseValue = this.getBaseValue(this.bidder, band);
            Constraint c = new Constraint(CompareType.EQ, 0.0);
            c.addTerm(-1.0, this.getValueVariable(band));
            c.addTerm(baseValue, this.getAlphaVariable(band));
            c.addTerm(baseValue * this.getIntrabandSynergyFactor(this.bidder, band), this.getBetaVariable(band));
            c.addTerm(baseValue, this.getGammaVariable(band));
            result.add(c);
        }
        return result;
    }

    Set<PartialMIP> generatePiecewiseLinearFunctionConstraints() {
        HashSet<PartialMIP> result = new HashSet<PartialMIP>();
        for (Band band : this.bidder.getWorld().getBands()) {
            ContinuousPiecewiseLinearFunction funcAlpha = this.alpha(band);
            Variable inputAlpha = this.worldPartialMip.getXVariable(this.bidder, band);
            Variable outputAlpha = this.getAlphaVariable(band);
            PiecewiseLinearPartialMIP partialMipAlpha = new PiecewiseLinearPartialMIP(funcAlpha, inputAlpha, outputAlpha, "aux_alpha_helper_" + SRVMBidderPartialMIP.createIndex(this.bidder, band) + "_");
            result.add(partialMipAlpha);
            ContinuousPiecewiseLinearFunction funcBeta = this.beta(band);
            Variable inputBeta = this.worldPartialMip.getXVariable(this.bidder, band);
            Variable outputBeta = this.getBetaVariable(band);
            PiecewiseLinearPartialMIP partialMipBeta = new PiecewiseLinearPartialMIP(funcBeta, inputBeta, outputBeta, "aux_beta_helper_" + SRVMBidderPartialMIP.createIndex(this.bidder, band) + "_");
            result.add(partialMipBeta);
            ContinuousPiecewiseLinearFunction funcGamma = this.gamma(band);
            Variable inputGamma = this.worldPartialMip.getXVariable(this.bidder, band);
            Variable outputGamma = this.getGammaVariable(band);
            PiecewiseLinearPartialMIP partialMipGamma = new PiecewiseLinearPartialMIP(funcGamma, inputGamma, outputGamma, "aux_gamma_helper_" + SRVMBidderPartialMIP.createIndex(this.bidder, band) + "_");
            result.add(partialMipGamma);
        }
        return result;
    }

    private ContinuousPiecewiseLinearFunction alpha(Band band) {
        int threshold = this.bidder.getSynergyThreshold().get(band.getName());
        boolean scale = false;
        HashMap<BigDecimal, BigDecimal> breakpoints = new HashMap<BigDecimal, BigDecimal>();
        breakpoints.put(BigDecimal.ZERO.setScale(0), BigDecimal.ZERO);
        breakpoints.put(new BigDecimal(threshold).setScale(0), new BigDecimal(threshold));
        BigDecimal key = new BigDecimal(band.getNumberOfLicenses()).setScale(0);
        breakpoints.put(key, new BigDecimal(threshold));
        ContinuousPiecewiseLinearFunction result = new ContinuousPiecewiseLinearFunction(breakpoints);
        return result;
    }

    private ContinuousPiecewiseLinearFunction beta(Band band) {
        int threshold = this.bidder.getSynergyThreshold().get(band.getName());
        boolean scale = false;
        HashMap<BigDecimal, BigDecimal> breakpoints = new HashMap<BigDecimal, BigDecimal>();
        for (int x = 0; x <= band.getNumberOfLicenses(); ++x) {
            double value = 0.0;
            if (x > 0) {
                value = Math.min(((double)threshold - 1.0) / (double)threshold, ((double)x - 1.0) / (double)x);
            }
            breakpoints.put(new BigDecimal(x).setScale(0), new BigDecimal(value));
        }
        ContinuousPiecewiseLinearFunction result = new ContinuousPiecewiseLinearFunction(breakpoints);
        return result;
    }

    private ContinuousPiecewiseLinearFunction gamma(Band band) {
        int threshold = this.bidder.getSynergyThreshold().get(band.getName());
        boolean scale = false;
        HashMap<BigDecimal, BigDecimal> breakpoints = new HashMap<BigDecimal, BigDecimal>();
        for (int x = 0; x <= band.getNumberOfLicenses(); ++x) {
            double log = 0.0;
            if (x - threshold >= 0) {
                log = Math.log(x - threshold + 1);
            }
            double value = Math.max(0.0, log);
            breakpoints.put(new BigDecimal(x).setScale(0), new BigDecimal(value));
        }
        ContinuousPiecewiseLinearFunction result = new ContinuousPiecewiseLinearFunction(breakpoints);
        return result;
    }

    private double getBaseValue(SRVMBidder bidder, Band band) {
        Preconditions.checkArgument((boolean)bidder.getBaseValues().containsKey(band.getName()));
        BigDecimal value = bidder.getBaseValues().get(band.getName());
        return value.floatValue();
    }

    private double getIntrabandSynergyFactor(SRVMBidder bidder, Band band) {
        Preconditions.checkArgument((boolean)bidder.getIntrabandSynergyFactors().containsKey(band.getName()));
        BigDecimal value = bidder.getIntrabandSynergyFactors().get(band.getName());
        return value.floatValue();
    }

    @Override
    public void appendVariablesToMip(MIP mip) {
        super.appendVariablesToMip(mip);
        for (Variable var : this.zVariables.values()) {
            mip.add(var);
        }
        mip.add(this.wVariable);
        for (Variable var : this.valueVariables.values()) {
            mip.add(var);
        }
        for (Variable var : this.alphaVariables.values()) {
            mip.add(var);
        }
        for (Variable var : this.betaVariables.values()) {
            mip.add(var);
        }
        for (Variable var : this.gammaVariables.values()) {
            mip.add(var);
        }
        for (PartialMIP partialMIP : this.generatePiecewiseLinearFunctionConstraints()) {
            partialMIP.appendVariablesToMip(mip);
        }
    }

    @Override
    public void appendConstraintsToMip(MIP mip) {
        super.appendConstraintsToMip(mip);
        for (Constraint constraint : this.generatewConstraints()) {
            mip.add(constraint);
        }
        for (Constraint constraint : this.generatezConstraints()) {
            mip.add(constraint);
        }
        for (Constraint constraint : this.generateInterBandSynergyConstraints()) {
            mip.add(constraint);
        }
        for (Constraint constraint : this.generateValueConstraints()) {
            mip.add(constraint);
        }
        for (PartialMIP partialMip : this.generatePiecewiseLinearFunctionConstraints()) {
            partialMip.appendConstraintsToMip(mip);
        }
    }
}

