/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.xorq;

import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.bidlang.generic.GenericBid;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.GenericWorld;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.domain.Allocation;
import org.spectrumauctions.sats.opt.domain.GenericAllocation;
import org.spectrumauctions.sats.opt.domain.WinnerDeterminator;

public class XORQWinnerDetermination<G extends GenericDefinition<T>, T extends Good>
implements WinnerDeterminator<T> {
    private Map<GenericValue<G, T>, Variable> bidVariables = new HashMap<GenericValue<G, T>, Variable>();
    private Set<GenericBid<G, T>> bids;
    private IMIP winnerDeterminationProgram;
    private Allocation<T> result = null;
    private GenericWorld<T> world;
    private double scalingFactor = 1.0;

    public XORQWinnerDetermination(Set<GenericBid<G, T>> bids) {
        Preconditions.checkNotNull(bids);
        Preconditions.checkArgument((bids.size() > 0 ? 1 : 0) != 0);
        this.bids = bids;
        double maxValue = -1.0;
        for (GenericBid<G, T> bid : bids) {
            for (GenericValue<G, T> value : bid.getValues()) {
                if (!(value.getValue().doubleValue() > maxValue)) continue;
                maxValue = value.getValue().doubleValue();
            }
        }
        if (maxValue > 4.83183819E8) {
            this.scalingFactor = 0.9 / maxValue * 5.3687091E8;
        }
        this.world = (GenericWorld)((Object)bids.iterator().next().getBidder().getWorld());
        this.winnerDeterminationProgram = this.createWinnerDeterminationMIP();
    }

    private IMIP createWinnerDeterminationMIP() {
        MIP winnerDeterminationProgram = new MIP();
        winnerDeterminationProgram.setObjectiveMax(true);
        for (GenericBid<G, T> bid : this.bids) {
            for (GenericValue<G, T> value : bid.getValues()) {
                Variable bidI = new Variable("Bid " + value.getId(), VarType.BOOLEAN, 0.0, 1.0);
                winnerDeterminationProgram.add(bidI);
                winnerDeterminationProgram.addObjectiveTerm(value.getValue().doubleValue() * this.scalingFactor, bidI);
                this.bidVariables.put(value, bidI);
            }
        }
        HashMap<GenericDefinition, Constraint> numberOfLotsConstraints = new HashMap<GenericDefinition, Constraint>();
        for (GenericBid<G, T> bid : this.bids) {
            Constraint exclusiveBids = new Constraint(CompareType.LEQ, 1.0);
            for (GenericValue<G, T> value : bid.getValues()) {
                exclusiveBids.addTerm(1.0, this.bidVariables.get(value));
                for (Map.Entry entry : value.getQuantities().entrySet()) {
                    GenericDefinition def = (GenericDefinition)entry.getKey();
                    int quantity = (Integer)entry.getValue();
                    Constraint numberOfLotsConstraint = (Constraint)numberOfLotsConstraints.get(def);
                    if (numberOfLotsConstraint == null) {
                        numberOfLotsConstraint = new Constraint(CompareType.LEQ, (double)def.numberOfLicenses());
                        numberOfLotsConstraints.put(def, numberOfLotsConstraint);
                    }
                    numberOfLotsConstraint.addTerm((double)quantity, this.bidVariables.get(value));
                }
            }
            winnerDeterminationProgram.add(exclusiveBids);
        }
        numberOfLotsConstraints.values().forEach(arg_0 -> ((MIP)winnerDeterminationProgram).add(arg_0));
        return winnerDeterminationProgram;
    }

    protected IMIP getMIP() {
        return this.winnerDeterminationProgram;
    }

    private Allocation<T> solveWinnerDetermination() {
        SolverClient solver = new SolverClient();
        IMIPResult mipResult = solver.solve(this.getMIP());
        return this.adaptMIPResult(mipResult);
    }

    @Override
    public WinnerDeterminator<T> getWdWithoutBidder(Bidder<T> bidder) {
        return new XORQWinnerDetermination<G, T>(this.bids.stream().filter(b -> !b.getBidder().equals(bidder)).collect(Collectors.toSet()));
    }

    @Override
    public Allocation<T> calculateAllocation() {
        if (this.result == null) {
            this.result = this.solveWinnerDetermination();
        }
        return this.result;
    }

    @Override
    public WinnerDeterminator<T> copyOf() {
        return new XORQWinnerDetermination<G, T>(this.bids);
    }

    @Override
    public void adjustPayoffs(Map<Bidder<T>, Double> payoffs) {
        for (GenericBid<G, T> bidPerBidder : this.bids) {
            Variable x = new Variable("x_" + bidPerBidder.getBidder().getId(), VarType.BOOLEAN, 0.0, 1.0);
            this.winnerDeterminationProgram.add(x);
            this.winnerDeterminationProgram.addObjectiveTerm(-payoffs.getOrDefault(bidPerBidder.getBidder(), 0.0).doubleValue(), x);
            Constraint x1 = new Constraint(CompareType.GEQ, 0.0);
            Constraint x2 = new Constraint(CompareType.LEQ, 0.0);
            x1.addTerm(-1.0, x);
            x2.addTerm(-5.3687091E8, x);
            bidPerBidder.getValues().forEach(b -> x1.addTerm(1.0, this.bidVariables.get(b)));
            bidPerBidder.getValues().forEach(b -> x2.addTerm(1.0, this.bidVariables.get(b)));
            this.winnerDeterminationProgram.add(x1);
            this.winnerDeterminationProgram.add(x2);
        }
    }

    private Variable getBidVariable(GenericValue<G, T> bundleBid) {
        return this.bidVariables.get(bundleBid);
    }

    private Allocation<T> adaptMIPResult(IMIPResult mipResult) {
        GenericAllocation.Builder<G, T> builder = new GenericAllocation.Builder<G, T>();
        for (GenericBid<G, T> bid : this.bids) {
            for (GenericValue<G, T> value : bid.getValues()) {
                if (!DoubleMath.fuzzyEquals((double)mipResult.getValue(this.getBidVariable(value)), (double)1.0, (double)0.001)) continue;
                builder.putGenericValue(bid.getBidder(), value);
            }
        }
        return new GenericAllocation(builder);
    }
}

